#!/usr/bin/env python
# -*- coding: utf-8 -*-
# -----------------------------------------------------------------------------
# Copyright INRIA
# Contributors: Nicolas P. Rougier (Nicolas.Rougier@inria.fr)
#
# DANA is a computing framework for the simulation of distributed,
# asynchronous, numerical and adaptive models.
#
# This software is governed by the CeCILL license under French law and abiding
# by the rules of distribution of free software. You can use, modify and/ or
# redistribute the software under the terms of the CeCILL license as circulated
# by CEA, CNRS and INRIA at the following URL
# http://www.cecill.info/index.en.html.
#
# As a counterpart to the access to the source code and rights to copy, modify
# and redistribute granted by the license, users are provided only with a
# limited warranty and the software's author, the holder of the economic
# rights, and the successive licensors have only limited liability.
#
# In this respect, the user's attention is drawn to the risks associated with
# loading, using, modifying and/or developing or reproducing the software by
# the user in light of its specific status of free software, that may mean that
# it is complicated to manipulate, and that also therefore means that it is
# reserved for developers and experienced professionals having in-depth
# computer knowledge. Users are therefore encouraged to load and test the
# software's suitability as regards their requirements in conditions enabling
# the security of their systems and/or data to be ensured and, more generally,
# to use and operate it in the same conditions as regards security.
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
# -----------------------------------------------------------------------------
import unittest
import numpy as np
from dana import Group
from tools import np_equal
from dana import ConnectionError
from dana import SharedConnection, SparseConnection, DenseConnection



class GroupMask(unittest.TestCase):
    def setUp(self):
        self.Z = Group((3,3))


    def test_mask_shape_1(self):
        self.Z.mask = np.ones((3,3))
        self.Z[...] = 1
        self.Z.setup()
        assert np_equal(self.Z.f0,np.ones((3,3)))

    def test_mask_shape_2(self):
        mask = np.ones((3,3))
        mask[1,1] = 0
        self.Z.mask = mask
        self.Z[...] = 1
        self.Z.setup()
        assert np_equal(self.Z.f0,mask)


if __name__ == "__main__":
    unittest.main()
    
