#!/usr/bin/env python
# -*- coding: utf-8 -*-

try:
    from setuptools import setup, find_packages, Command
except:
    from distutils.core import setup, find_packages, Command

import subprocess
import os


class PyTest(Command):
    user_options = [('test-runner=',
                     't',
                     'test runner to use; by default, multiple py.test runners are tried')]
    command_consumes_arguments = True

    def initialize_options(self):
        self.test_runner = None
        self.args = []

    def finalize_options(self):
        pass

    def runner_exists(self, runner):
        syspaths = os.getenv('PATH').split(os.pathsep)
        for p in syspaths:
            if os.path.exists(os.path.join(p, runner)):
                return True

        return False

    def run(self):
        # only one test runner => just run the tests
        runners = ['py.test-2.7', 'py.test-3.3']
        if self.test_runner:
            runners = [self.test_runner]

        have_runner = False
        for runner in runners:
            if self.runner_exists(runner):
                have_runner = True

        if not have_runner:
            if self.runner_exists('py.test'):
                runners = ['py.test']
            else:
                print('No py.test runners found, can\'t run tests.')
                print('Tried: {0}.'.format(', '.join(runners + ['py.test'])))
                raise SystemExit(100)

        for runner in runners:
            if len(runners) > 1:
                print('\n' * 2)
            print('Running tests using "{0}":'.format(runner))

            retcode = 0
            cmd = [runner]
            for a in self.args:
                cmd.append(a)
            cmd.append('test')
            t = subprocess.Popen(cmd)
            rc = t.wait()
            retcode = t.returncode or retcode

        raise SystemExit(retcode)

setup(
    name='daploader',
    version='0.0.9',
    description='Dap archives loader and checker',
    long_description=''.join(open('README.rst').readlines()),
    keywords='devassiatnt, lint, dap',
    author='Miro Hrončok',
    author_email='miro@hroncok.cz',
    license='GPLv2+',
    url='https://github.com/hroncok/daploader',
    packages=find_packages(),
    install_requires=['PyYAML', 'requests', 'sh'],
    entry_points={'console_scripts': [
        'daplint = daploader.daplint:lint',
        'dapi = daploader.dapicli:cli',
    ]},
    data_files=[('daploader', ['daploader/dapi.help'])],
    classifiers=['Development Status :: 4 - Beta',
                 'Intended Audience :: Developers',
                 'License :: OSI Approved :: GNU General Public License v2 or later (GPLv2+)',
                 'Operating System :: POSIX :: Linux',
                 'Programming Language :: Python',
                 'Programming Language :: Python :: 2',
                 'Programming Language :: Python :: 2.6',
                 'Programming Language :: Python :: 2.7',
                 'Programming Language :: Python :: 3',
                 'Programming Language :: Python :: 3.3',
                 ],
    cmdclass={'test': PyTest}
)
