#!/usr/bin/python3

#DATA PROCESSOR Processor.py
#written by Beef Wellington Inc.
#copyleft software with the GNU PUBLIC LICENSE v3

#import modules
import os, pickle
from sqlite3 import connect

#process manager for process function in ClassProcessor
#ProMan is short for Process Manager
class ProMan:
	#unpack while returning data
	@staticmethod
	def extract(aFile, ldType=0):
		#check if path exists
		if os.path.exists(aFile):
			#check if file is a .prodf file
			fileExtension = aFile.split(".")
			if fileExtension[-1] == "prodf":
				#see what parameter the function got
				if ldType != 0 and ldType != 1:
					print("error : UNABLE TO PARSE PARAMETER")
					return
				else:
					try:
						return(pickle.load(open(aFile, "rb"))[ldType])
					except:
						print("error : UNABLE TO LOAD DATA")
						return
			else:
				print("error : INVALID FILE EXTENSION")
				return
		else:
			print("error : CANNOT FIND PATH")
			return
	#prints out data
	@staticmethod
	def prints(aFile, aType=0):
		if os.path.exists(aFile):
			(daFile, exten) = aFile.split(".")
			if exten == "prodf":
				try:
					data = pickle.load(open(aFile, "rb"))
				except:
					print("error : CANNOT LOAD DATA")
					return
				if not isinstance(data, list):
					print("error : INVALID DATA TYPE")
					return
				aPrint = ""
				if aType == 1:
					try:
						data = data[1]
						if not isinstance(data, dict):
							print("error : INCORRECT TYPE FOR DATA")
							return
						try:
							average = str(data["average"])
							minimum = str(data["minimum"])
							maximum = str(data["maximum"])
						except:
							print("error : UNABLE TO RETRIEVE DATA FROM DICTIONARY")
							return
					except:
						print("error : CANNOT RETRIEVE DATA FROM LIST")
						return
					stats = "average=" + average + ",\nminimum=" + minimum + ",\nmaximum=" + maximum
					aPrint = stats
				elif aType == 0:
					db = ""
					if not isinstance(data[0], list):
						print("error : INCORRECT DATA TYPE")
						return
					for item in data[0]:
						db = db + str(item) + "%,\n"
					aPrint = db
				else:
					print("error : INVALID PARAMETER")
					return
				try:
					print("\n" + aPrint + "\n")
				except:
					print("error : UNABLE TO PRINT DATA")
					return
			else:
				print("error : INVALID FILE EXTENSION")
				return
		else:
			print("error : CANNOT FIND PATH")
			return
	#get data from database
	@staticmethod
	def getSQL(aFile, nTable, inList=True):
		(theFile, extension) = aFile.split(".")
		if extension != "sqlite":
			print("error : FILE INPUTED NOT SQLITE FILE")
			return
		if os.path.exists(aFile):
			try:
				conn = connect(aFile)
				cur = conn.cursor()
				cmdLine = "SELECT * FROM " + str(nTable)
				data = cur.execute(cmdLine)
			except:
				print("error : CANNOT GET DATA FROM FILE")
				return
			aList = []
			try:
				for item in data:
					aList.append(item)
			except:
				print("error : CANNOT START PARSE LOOP")
			if inList != True and inList != False:
				print("error : UNIDENTIFIED PARAMETER")
				return
			if inList:
				try:
					for item in aList:
						if isinstance(item, tuple):
							newItem = []
							for nest in item:
								newItem.append(nest)
							aList.remove(item)
							aList.append(newItem)
						else:
							pass
				except:
					print("error : UNABLE TO PROCESS TUPLE")
					return
			else:
				pass
			try:
				conn.commit()
				conn.close()
			except:
				print("error : CANNOT COMMIT CHANGES TO DATABSE")
				return
			return(aList)
		else:
			print("error : UNABLE TO FIND DATA FROM FILE")
			return
