#!/usr/bin/python3

#DATA PROCESSOR __init__.py
#written by Beef Wellington Inc.
#copyleft software with the GNU PUBLIC LICENSE v3

#import modules
import os, pickle, math
from sqlite3 import connect

#objective dataProcessor class
class ClassProcessor(list):
	#main processing function
	@staticmethod
	def Process(aFile, processN, save=False, sqlIt=False):
		#initialize lists
		uopData = []
		upData = []
		#check parameters:
		if save != False and save != True:
			print("error : INVALID PARAMETER")
			return
		if sqlIt != False and sqlIt != True:
			print("error : INVALID PARAMETER")
			return
		#try to open a file
		if not isinstance(aFile, list):
			if not os.path.exists(aFile):
				print("error : CANNOT FIND FILE WITH FRACTIONS")
				return
			try:
				#default to read
				data = open(aFile)
			except:
				print("error : CANNOT OPEN FILE INPUTED")
				return
			#get initial data
			for item in data:
				upData.append(item)
					#format the data
			try:
				for item in upData:
					data = item.split(" ")
			except:
				print("error : UNABLE TO SPLIT THE DATA")
				return
		elif isinstance(aFile, list):
			data = aFile
		#convert data into percent
		for item in data:
			try:
				try:
					(Num, Denum) = item.split("/")
				except:
					print("error : UNABLE TO PARSE NUMERATOR AND DENUMENATOR")
					return
				try:
					percent = (float(Num) / float(Denum)) * 100
				except:
					print("error : UNABLE TO PARSE PERCENTAGE")
					return
				uopData.append(percent)
			except:
				print("error : CANNOT PARSE DATA INTO PERCENTS")
				return
		#order the lists
		try:
			purData = sorted(uopData, key=float)
		except:
			print("error : CANNOT SORT PROCESSED DATA")
			return
		#round all the nums
		pData = []#fully processed data
		for num in purData:
			newNum = math.ceil(num*10)/10
			pData.append(newNum)
		#open files for saving
		if not os.path.exists("process"):
			os.mkdir("process")
		if save:
			try:
				os.chdir("process")
				os.mkdir(processN)
				os.chdir(processN)
				#open file for saving
				theComputerData = open("computerData.prodf", "wb")
			except:
				print("error : CANNOT CREATE FILES NEEDED TO SAVE DATA")
				return
		#prepare data for saving
		initList = []
		#calculate average and other stats
		average = 0
		for item in pData:
			average = average + item
		try:
			average = average / len(pData)
			minimum = min(pData)
			maximum = max(pData)
			average = math.ceil(average*10)/10
		except:
			print("error : UNABLE TO PROCESS AVERAGE MIN MAX")
			return
		#write stats to dictionary
		resultsDict = {"average":average, "minimum":minimum, "maximum":maximum}
		#insert stats and data into main list
		initList.append(pData)
		initList.append(resultsDict)
		#save data to files
		if save:
			try:
				pickle.dump(initList, theComputerData)
			except:
				print("error : CANNOT SAVE DATA TO FILE")
				return
		#save data to SQLite database
		if sqlIt:
			if save:
				try:
					os.chdir("..")
				except:
					print("error : UNABLE TO SWITCH DIRECTORIES")
					return
			else:
				pass
			try:
				#check for existing databases
				if not os.path.exists("processDb.sqlite"):
					try:
						open("processDb.sqlite", "w")
						try:
							try:
								conn = connect("processDb.sqlite")
								cur = conn.cursor()
							except:
								print("error : UNABLE TO CONNCET TO DATABASE")
								return
							try:
								cur.execute("CREATE TABLE mainTB (PROCESSNAME text, PROCESSAVERAGE float, PROCESSMINIMUM float, PROCESSMAXIMUM float)")
							except:
								print("error : UNABLE TO CREATE TABLE IN DATABASE")
								return
							try:
								conn.commit()
							except:
								print("error : UNABLE TO SAVE DATABASE")
								return
							conn.close()
						except:
							print("error : CANNOT CREATE DATABASE")
							return
					except:
						print("error : CANNOT CREATE DATABSE FILE")
						return
				try:
					conn = connect("processDb.sqlite")
					cursor = conn.cursor()
				except:
					print("error : CANNOT GET CONNECTED TO DATABASE")
					return
				try:
					try:
						cursor.execute("INSERT INTO mainTB (PROCESSNAME, PROCESSAVERAGE, PROCESSMINIMUM, PROCESSMAXIMUM) VALUES (?, ?, ?, ?)", (processN, average, minimum, maximum))
					except:
						print("error : CANNOT EXECUTE INSERT INTO DATABASE")
						return
					try:
						conn.commit()
						conn.close()
					except:
						print("error : CANNOT COMMIT CHANGES TO DATABASE")
						return
				except:
					print("error : CANNOT INSERT THE DATA INTO DATABASE")
					return
			except:
				print("error : UNABLE TO SAVE DATA TO DATABASE")
				return
			if save:
				try:
					os.chdir(processN)
				except:
					pass
			else:
				od.chdir("..")
		#return data
		#do not move, for the function will exit automatically
		return(initList)
	def __init__(self, aFile, processN):
		try:
			list.__init__([])
		except:
			print("error : UNABLE TO CREATE INSTANCE OF SELF")
			return
		try:
			self.append(self.Process(aFile, processN, False, False))
		except:
			print("error : UNABLE TO PROCESS DATA THROUGH CLASS")
			return
		if isinstance(processN, str):
			self.name = processN
		else:
			try:
				self.name = str(processN)
			except:
				print("error : UNABLE TO STRING PARSE PROCESS NAME")
				return
		try:
			self.data = self[0]
			self.dataRaw = self[0][0]
			self.dataStats = self[0][1]
		except:
			print("error : UNABLE TO RETRIEVE DATA FROM ARRAY")
			return
	#returns data in text/string format
	def read(self, aType=0):
		finalStr = ""
		if aType == 0:
			for item in self.dataRaw:
				try:
					item = str(item) + "%, "
					finalStr = finalStr + item
				except:
					print("error : UNABLE TO PROCESS DATA TO READ")
					return
		elif aType == 1:
			data = self.dataStats
			try:
				finalStr = "average=" + str(data["average"]) + ",\nminimum=" + str(data["minimum"]) + ",\nmaximum=" + str(data["maximum"])
			except:
				print("error : UNABLE TO PROCESS READABLE DATA")
				return
		else:
			print("error : UNABLE TO PARSE PARAMETER")
			return
		return(finalStr)
	#dumps data into a file
	def save(self, inDir="null"):
		if inDir != "null":
			if os.path.exists(inDir):
				try:
					os.chdir(inDir)
				except:
					pass
			else:
				try:
					os.mkdir(inDir)
					try:
						os.chdir(inDir)
					except:
						pass
				except:
					pass
		try:
			fileName = "data" + self.name + ".obj"
			pickle.dump(self, open(fileName, "wb"))#an obj file is an object file which requires a certain library to open
		except:
			print("error : UNABLE TO SAVE DATA TO FILES")
			return
		if inDir != "null":
			try:
				os.chdir("..")
			except:
				pass
		else:
			pass
