#NEXUS
[MacClade 3.06 registered to David H. A. Fitch, New York University]

BEGIN DATA;
DIMENSIONS  NTAX=8 NCHAR=36;

[!Rhabditid nematode male tail characters (with illustrations) for D.H.A.
Fitch, 1997, "Evolution of male tail development in rhabditid nematodes
related to Caenorhabditis elegans", Syst. Biol. 46(1):145-179.

Note that the character numbers correspond directly to those listed in
Appendix 7 of the paper, but the state designators are numbers in this file
and lowercase letters in the paper (a '1' in the file is equivalent to an
'a' in the paper, and so on).

Contact:
David H. A. Fitch
Department of Biology
New York University
Room 1009 Main Building
100 Washington Square East
New York, NY  10003
(212) 998-8254
Fax:  (212) 995-4015
E-mail:  fitch@acf2.nyu.edu
WWW:  http://www.nyu.edu/projects/fitch
]
FORMAT SYMBOLS= " 1 2 3 4 5" MISSING=? GAP=-  INTERLEAVE ;OPTIONS
MSTAXA=UNCERTAIN ;

CHARLABELS
	[1]	'Fan:_anterior_conformation'	[2]
	'Fan:__anterior_position'	[3]	'Fan:__e
xtension'	[4]	'Body_shape:__overall_shape'	[5]
	'Body_shape:__tail_tip'
	[6]	'Phasmid:__position'	[7]	'Rays:__ray_8'	[8]
	'Rays:__tip_position_for_1,
2,4,8'	[9]	'Rays:__ray_6'	[10]	'Rays:__ray_3_position'
	[11]	Overall_retraction	[12]
	'Terminal_cells:__retraction'	[13]	'Terminal_c
ells:__fusion'	[14]	'Ray_cell_associations:__ray_1'	[15]
	'Ray_cell_associati
ons:__ray_2'
	[16]	'Ray_cell_associations:__ray_3'	[17]
	'Ray_cell_associations:__ray_4'	[
18]	'Ray_cell_associations:__ray_5'	[19]
	'Ray_cell_associations:__ray_6'	[20
]	'Ray_cell_associations:__ray_7'
	[21]	'Ray_cell_associations:__ray_8'	[22]
	'DV_position_of_Rnst:__ray_1'	[23
]	'DV_position_of_Rnst:__ray_2'	[24]
	'DV_position_of_Rnst:__ray_4'	[25]	'se-
set_boundary_position'
	[26]	'Rn.p_position:__R1.p'	[27]	'Rn.p_position:__R2.p'
	[28]	'Rn.p_position
:__R6.p'	[29]	'Rn.p_position:__R9.p'	[30]
	'Rn.p_cell_fusions:__R1.p'
	[31]	'Rn.p_cell_fusions:__R2.p'	[32]
	'Rn.p_cell_fusions:__R3.p'	[33]	'Rn.p_
cell_fusions:__R4.p'	[34]	'Rn.p_cell_fusions:__R5.p'	[35]
	'Rn.p_cell_fusions
:__R6.p'
	[36]	'Rn.p_cell_fusions:__R7.p'
	;
STATELABELS
	1  '1:_open' '2:_closed',
	2  '1:_near_base_of_spicules' '2:_near_cloaca',
	3  '1:_broad' '2:_narrow',
	4  '1:_blunt' '2:_elongate',
	5  '1:_peloderan' '2:_leptoderan',
	6  '1:_posterior' '2:_lateral',
	7  '1:_present' '2:_absent',
	8  '1:_at_margin' '2:_on_dorsal_or_ventral_surface',
	9  '1:_narrow,_uniform,_open' '2:_broad,_tapered,_closed',
	10  '1:_separate' '2:_tendency_to_fuse_with_ray_4',
	11  '1:_strong' '2:_weak',
	12  '1:_present' '2:_absent',
	13  '1:_do_not_fuse' '2:_fuse',
	14  '1:_R1.p' '2:_R1.p+R2.p' '3:_R2.p+R3.p' '4:_R3.p+R4.p',
	15  '1:_R2.p' '2:_R2.p+R3.p' '3:_R3.p' '4:_R3.p+R4.p',
	16  '1:_R3.p' '2:_R2.p+R3.p' '3:_R3.p+R4.p' '4:_R6.p',
	17  '1:_R4.p' '2:_R4.p+R6.p' '3:_R6.p' '4:_R6.p+R7.p',
	18  '1:_R5.p' '2:_R4.p+R6.p' '3:_R5.p+R6.p',
	19  '1:_R6.p' '2:_R6.p+R7.p',
	20  '1:_R7.p' '2:_R7.p+R9.p' '3:_migrates_into_R7.p',
	21  '1:_R8.p' '2:_R7.p' '3:_(No_ray_8)',
	22  '1:_seam-hyp_7_border' '2:_within_set',
	23  '1:_seam-hyp_7_border' '2:_within_hyp_7',
	24  '1:_seam-hyp_7_border' '2:_within_hyp_7',
	25  '1:_near_base_of_spicules' '2:_near_cloaca',
	26  '1:_within_seam' '2:_ventral_of_seam',
	27  '1:_within_seam' '2:_ventral_of_seam',
	28  '1:_ventral_of_seam' '2:_within_seam',
	29  '1:_strictly_lateral' '2:_extends_to_dorsal_midline',
	30  '1:_remains_unfused' '2:_fuses_with_R2.p+R3.p' '3:_fuses_with_set'
'4:_fuses_with_se',
	31  '1:_remains_unfused' '2:_fuses_with_R2.p+R3.p' '3:_fuses_with_set'
'4:_fuses_with_se',
	32  '1:_remains_unfused' '2:_fuses_with_R2.p+R3.p' '3:_fuses_with_set'
'4:_fuses_with_se',
	33  '1:_remains_unfused' '2:_fuses_with_set' '3:_fuses_with_se',
	34  '1:_remains_unfused' '2:_fuses_with_R7.p' '3:_fuses_with_R6.p+R7.p'
'4:_fuses_with_set' '5:_fuses_with_hyp7_or_possibly_',
	35  '1:_remains_unfused' '2:_fuses_with_R5.p+R7.p' '3:_fuses_with_se'
'4:_fuses_with_hyp7',
	36  '1:_remains_unfused' '2:_fuses_with_R5.p' '3:_fuses_with_R5.p+R6.p'
'4:_fuses_with_hyp7',
;

MATRIX

C._briggsae          221111122211222321211222211123332444
C._elegans           221111122111222321211222211123332444
R._myriophila        111121111112111112112111111111111144
R._blumi             111121211112111112113111111111111144
Rh._axei             1122211111221122412111111111144435{34}4
P._typica            111111111111112232121111111214443242
T._palmarum          111112111111144441231111122212221323
Pe._strongyloides    111112111111133443211111111114443242
;
END;

BEGIN ASSUMPTIONS;
	OPTIONS  DEFTYPE=unord PolyTcount=MINSTEPS ;
	CHARSET  MaleMulti  =  14-18 30-36;
	CHARSET  MaleIndep  =  1 6 9-36;
	CHARSET  MaleNonind  =  2-5 7-8;
END;

BEGIN TREES;

	TRANSLATE
		1	C._briggsae,
		2	C._elegans,
		3	R._myriophila,
		4	R._blumi,
		5	Rh._axei,
		6	P._typica,
		7	T._palmarum,
		8	Pe._strongyloides
	;
	TREE I =  [&R] ((((1,2),((3,5),4)),6),(7,8));
	TREE II =  [&R] ((((1,2),((3,4),5)),6),(7,8));
	TREE III =  [&R] (((1,2),(((3,5),4),6)),(7,8));
	TREE  * IV =  [&R] (((1,2),(((3,4),5),6)),(7,8));
	TREE V =  [&R] (((((1,2),6),8),((3,4),5)),7);
	TREE Polytomy =  [&R] (((1,2),(3,4,5),6),(7,8));

END;


BEGIN NOTES;
	PICTURE  TAXON=1 FORMAT=PICT SOURCE=RESOURCE  PICTURE= 136;
	PICTURE  TAXON=2 FORMAT=PICT SOURCE=RESOURCE  PICTURE= 137;
	PICTURE  TAXON=3 FORMAT=PICT SOURCE=RESOURCE  PICTURE= 138;
	PICTURE  TAXON=4 FORMAT=PICT SOURCE=RESOURCE  PICTURE= 139;
	PICTURE  TAXON=5 FORMAT=PICT SOURCE=RESOURCE  PICTURE= 140;
	PICTURE  TAXON=6 FORMAT=PICT SOURCE=RESOURCE  PICTURE= 141;
	PICTURE  TAXON=7 FORMAT=PICT SOURCE=RESOURCE  PICTURE= 142;
	PICTURE  TAXON=8 FORMAT=PICT SOURCE=RESOURCE  PICTURE= 143;
END;

BEGIN MACCLADE;
Version 3.05;
LastModified -1343415132;
Singles 0000&/0;
END;
