#!/usr/bin/env python
# -*- coding: utf-8 -*-

# This work was created by participants in the DataONE project, and is
# jointly copyrighted by participating institutions in DataONE. For
# more information on DataONE, see our web site at http://dataone.org.
#
#   Copyright 2013 DataONE
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
:mod:`setup`
============

:Synopsis: Create egg.
:Author: DataONE (Dahl)
:Notes:
  The script should be run in the current directory with ./setup.py.

  The setup() parameters are described here:
  http://pythonhosted.org/setuptools/setuptools.html
  http://docs.python.org/2/distutils/setupscript.html

  Notes:

  - The goal in this script is to automatically include all files (.py and
    others) that are in Subversion in the package and then install those same
    files. This turned out to be tricky because, without a list of packages
    specified with the packages parameter, nothing gets installed. While, with a
    list of packages specified, unversioned files are included in package and
    are also installed. The solution is to specify packages only at install
    time, not at build time.

  - package_data is only used when building binary packages (bdist). It is not
    relevant for source packages (sdist).

  - I've seen conflicting information for MANIFEST.in, regarding if it works
    for sdist and/or bdist and have not checked bdist. We don't use MANIFEST
    or MANIFEST.in because they imply a fixed set of files, and we want to
    automatically include only versioned files.

  - include_package_data = True does not affect which files get included in the
    package, only which files that are installed. Without include_package_data,
    data files that are included in the package because they are versioned are
    not installed.
"""
import locale
import os
import re
#import subprocess
#import xml.etree.ElementTree as element_tree
import setuptools
#import distutils.core
import sys

import service

# Metadata.
name = 'dataone.generic_member_node'
version = service.__version__
description = 'DataONE Generic Member Node (GMN)'
author = 'DataONE Project'
author_email = 'developers@dataone.org'
url = 'http://dataone.org'
license = 'Apache License, Version 2.0'

def main():
  # Enable SVN to work with filenames containing Unicode.
  #locale.setlocale(locale.LC_ALL, 'en_US.UTF-8')

  if 'install' in sys.argv:
    packages = setuptools.find_packages()
  else:
    packages = None
  #create_manifest()

  #print packages

  #distutils.core.setup(
  setuptools.setup(
    # Metadata
    name = name,
    version = version,
    description = description,
    author = author,
    author_email = author_email,
    url = url,
    license = license,
    # Contents (modified by MANIFEST.in)
    #py_modules = get_py_modules(),
    #data_files = get_data_files(),
    packages = packages,
    include_package_data = True,
    # Dependencies that are available through PyPI.
    install_requires = [
      # GMN uses dataone.common directly but, to keep the versions consistent,
      # let it be included by dataone.libclient.
      #'dataone.common',
      'dataone.libclient == 1.2.6',
      'dataone.certificate_extensions == 1.1.3',
      'django == 1.6.1',
      'pyxb == 1.2.3',
      'iso8601 == 0.1.4',
      'psycopg2 == 2.5.2',
      # GMN does not use the CLI programmatically -- it's just included because
      # the CLI is a convenient way to interact with GMN . So the latest version
      # is installed instead of a specific version.
      'dataone.cli >= 1.0.0',
    ],
  )


##def create_manifest_in():
##  with open('MANIFEST.in', 'w') as f:
##    for p in get_unversioned_python_modules():
##      f.write(u'exclude {0}\n'.format(p).encode('utf-8'))
#
#def create_manifest():
#  with open(get_manifest_path(), 'w') as f:
#    for p in get_versioned_files():
#      #if p != 'MANIFEST':
#        #f.write(u'include {0}\n'.format(p).encode('utf-8'))
#        f.write(u'./{0}\n'.format(p).encode('utf-8'))
#
#
#def get_versioned_files():
#  svn_xml = subprocess.check_output(['svn', 'status', '--verbose', '--xml'])
#  root = element_tree.fromstring(svn_xml)
#  paths = []
#  for entry in root.find('target').findall('entry'):
#    if entry.find('wc-status').get('item') != 'unversioned':
#      p = entry.get('path')
#      if os.path.isfile(p):
#        paths.append(p)
#  return paths
#
#
#def get_py_modules():
#  modules = []
#  with open(get_manifest_path(), 'r') as f:
#    for p in f:
#      #p = re.match(r'include (.*)', p).group(1)
#      base, ext = os.path.splitext(p)
#      if ext != '.py':
#        continue
#      base.replace('/', '.')
#      modules.append(base)
#  return modules
#
#
#def get_data_files():
#  directories = {}
#  with open(get_manifest_path(), 'r') as f:
#    for p in f:
#      #p = re.match(r'include (.*)', p).group(1)
#      if os.path.splitext(p)[1] == '.py':
#        continue
#      d, n = os.path.split(p)
#      try:
#        directories[d].append(n)
#      except KeyError:
#        directories[d] = [n]
#  return directories.items()
#
#
#def get_manifest_path():
#  return os.path.join(os.path.dirname(__file__), 'MANIFEST')
#
#if __name__ == '__main__':
#  main()
#
###!/usr/bin/env python
### -*- coding: utf-8 -*-
##
### This work was created by participants in the DataONE project, and is
### jointly copyrighted by participating institutions in DataONE. For
### more information on DataONE, see our web site at http://dataone.org.
###
###   Copyright 2013 DataONE
###
### Licensed under the Apache License, Version 2.0 (the "License");
### you may not use this file except in compliance with the License.
### You may obtain a copy of the License at
###
###   http://www.apache.org/licenses/LICENSE-2.0
###
### Unless required by applicable law or agreed to in writing, software
### distributed under the License is distributed on an "AS IS" BASIS,
### WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
### See the License for the specific language governing permissions and
### limitations under the License.
##
##'''
##:mod:`setup`
##============
##
##:Synopsis: Create egg.
##:Author: DataONE (Dahl)
##:Notes:
##  The script should be run in the current directory with ./setup.py.
##
##  distutils docs: https://docs.python.org/2/distutils/
##
##  This project uses MANIFEST to directly specify each file that should be
##  distributed. Remember to update the MANIFEST file when files are added or
##  deleted in the project.
##'''
##
##import os
##import re
##import distutils.core
##
##import service
##
### Metadata.
##name = 'dataone.generic_member_node'
##version = service.__version__
##description = 'DataONE Generic Member Node (GMN)'
##author = 'DataONE Project'
##author_email = 'developers@dataone.org'
##url = 'http://dataone.org'
##license = 'Apache License, Version 2.0'
##
##def main():
##  distutils.core.setup(
##    # Metadata
##    name = name,
##    version = version,
##    description = description,
##    author = author,
##    author_email = author_email,
##    url = url,
##    license = license,
##    packages = [
##      'deployment',
##      'service',
##      'service.mn',
##      'service.mn.management',
##      'service.mn.management.commands',
##      'service.mn.middleware',
##      'service.mn.templates',
##      'service.mn.views',
##      'service.stores',
##      'service.stores.object',
##      'service.stores.sysmeta',
##      'tests',
##      'tests.unittest2',
##      'tests.unittest2.test',
##    ],
##    # Include data files (non-.py files) that
##    include_package_data = True,
##    # Dependencies that are available through PyPI.
##    install_requires = [
##      # GMN uses dataone.common directly but, to keep the versions consistent,
##      # let it be included by dataone.libclient.
##      #'dataone.common',
##      'dataone.libclient == 1.2.6',
##      'dataone.certificate_extensions == 1.1.3',
##      'django == 1.6.1',
##      'pyxb == 1.2.3',
##      'iso8601 == 0.1.4',
##      'psycopg2 == 2.5.2',
##      # GMN does not use the CLI programmatically -- it's just included because
##      # the CLI is a convenient way to interact with GMN . So the latest version
##      # is installed instead of a specific version.
##      'dataone.cli >= 1.0.0',
##    ],
##  )
##
##
if __name__ == '__main__':
  main()
