  #def generate(format='xml'):
  #  assert(format in ['xml','pretty-xml','n3','rdfa','json','pretty-json','turtle','nt', 'trix',])
  #  res = example1()
  #  serializer = foresite.RdfLibSerializer(format)
  #  res.register_serialization(serializer)
  #  doc = res.get_serialization()
  #  return doc.data


  #def example1():
  #  '''Basic example of a single science metadata document and a science data
  #  object. That the two form a package is inferred by their presence in the
  #  resource map aggregation.
  #
  #  Relationships between aggregated items are defined using terms from the CITO
  #  ontology (
  #  http://speroni.web.cs.unibo.it/cgi-bin/lode/req.py?req=http:/purl.org/spar/cito
  #  ) as described in the DataCite to RDF mapping by David Shotton and Silvio
  #  Peroni in:
  #
  #  http://opencitations.wordpress.com/2011/06/30/datacite2rdf-mapping-datacite-metadata-scheme-terms-to-ontologies-2/
  #
  #  '''
  #  #Add the cito namespace
  #  foresite.utils.namespaces['cito'] = Namespace("http://purl.org/spar/cito/")
  #
  #  scidata_id = "scidata_id"
  #  scidata_uri = URIRef('https://cn.dataone.org/object/%s' % scidata_id)
  #  scimeta_id = "scimeta_id"
  #  scimeta_uri = URIRef('https://cn.dataone.org/object/%s' % scimeta_id)
  #
  #  #create a reference to the science data
  #  #Create a resolvable URI for the object
  #  res_1 = foresite.AggregatedResource(scidata_uri)
  #  #Capture the DataONE identifier as a dcterms:identifier entry
  #  res_1._dcterms.identifier = scidata_id
  #  #optional description
  #  res_1._dcterms.description = "A reference to a science data object using a DataONE identifier"
  #  #res_1._dcterms.type = URIRef('http://purl.org/dc/dcmitype/Dataset')
  #  res_1._cito.isDocumentedBy = scimeta_uri
  #
  #  #create a reference to the science metadata
  #  res_2 = foresite.AggregatedResource(scimeta_uri)
  #  #Capture the DataONE identifier as a dcterms:identifier entry
  #  res_2._dcterms.identifier = scimeta_id
  #  # We could reference the science data here - but that only works for a
  #  # single data set
  #  #res_2._dcterms.references = scidata_id
  #  res_2._dcterms.description = "A reference to a science metadata document using a DataONE identifier."
  #  res_2._cito.documents = scidata_uri
  #
  #  #create the aggregation
  #  #The identifier here is arbitrary, using an internal id here.
  #  aggr = foresite.Aggregation("aggregation_id")
  #  aggr._dcterms.title = "Simple aggregation of science metadata and data"
  #
  #  #and add the aggregate resources to the aggregation
  #  aggr.add_resource(res_1)
  #  aggr.add_resource(res_2)
  #
  #  #Now create the resource map that will hold the aggregation
  #  #The identifier for the resource map is treated similarly to the identifiers
  #  #for the data and metadata entries.
  #  resource_map_id = "resource_map_id"
  #  resmap = foresite.ResourceMap("https://cn.dataone.org/object/%s" % resource_map_id)
  #  resmap._dcterms.identifier = resource_map_id
  #  resmap.set_aggregation(aggr)
  #  return resmap

#===============================================================================

class ResourceMapParser(object):
  def __init__(self):
    pass


  def simple_parse_resource_map(self, xml_doc):
    '''Parse a simple resource map.

    Parse an OAI-ORE resource map for the common scenario where one
    resource map describes an aggregation containing a single Science Metadata
    object and one or more Science Data objects described by that object.

    The resource map must be in RDF:XML format, currently the only format
    supported by DataONE.

    :xml_doc: The RDF:XML document.
    '''
    dom = xml.dom.minidom.parseString(xml_doc)
    print dom.toxml()
    res = {
      'map_pid': '',
      'sci_meta': [],
      'sci_data': [],
    }

    for desc in dom.getElementsByTagNameNS(RDF_NS, 'Description'):
      documentedBy = desc.getElementsByTagNameNS(CITO_NS, 'isDocumentedBy')
      if documentedBy and len(documentedBy) > 0:
        pid_element = desc.getElementsByTagNameNS(DCTERMS_NS, 'identifier')
        if pid_element and pid_element.item(0) and pid_element.item(0).hasChildNodes():
          #scidata.pid = pid_element.item(0).firstChild.nodeValue
          #if len(documentedBy) > 1:
          #  print_warn('Using the first Science Metadata Object for %s' % scidata.pid)
          #about_url = documentedBy.item(0).getAttributeNS(RDF_NS, 'resource')
          #scidata.documented_by = about_url
          res['sci_data'].append(pid_element.item(0).firstChild.nodeValue)
      # scimeta?
      elif desc.getElementsByTagNameNS(CITO_NS, 'documents'):
        #self.scimeta = DataObject(dirty=False)
        pid_element = desc.getElementsByTagNameNS(DCTERMS_NS, 'identifier')
        if pid_element and pid_element.item(0) and pid_element.item(0).hasChildNodes():
          res['sci_meta'].append(pid_element.item(0).firstChild.nodeValue)

    return res


#  def _generate_resmap(self, mn_client_base_url):
#    ''' Create a package.
#    '''
#    # Create the aggregation
#    foresite.utils.namespaces['cito'] = Namespace("http://purl.org/spar/cito/")
#    aggr = foresite.Aggregation(self.pid)
#    aggr._dcterms.title = 'Simple aggregation of science metadata and data.'
#
#    # Create a reference to the science metadata
#    uri_scimeta = URIRef(self.scimeta.url)
#    res_scimeta = foresite.AggregatedResource(uri_scimeta)
#    res_scimeta._dcterms.identifier = self.scimeta.pid
#    res_scimeta._dcterms.description = 'Science metadata object.'
#
#    # Create references to the science data
#    resource_list = []
#    for scidata in self.scidata_dict.values():
#      uri_scidata = URIRef(scidata.url)
#      res_scidata = foresite.AggregatedResource(uri_scidata)
#      res_scidata._dcterms.identifier = scidata.pid
#      res_scidata._dcterms.description = 'Science data object'
#      res_scidata._cito.isDocumentedBy = uri_scimeta
#      res_scimeta._cito.documents = uri_scidata
#      resource_list.append(res_scidata)
#
#    # Add all the resources.
#    aggr.add_resource(res_scimeta)
#    for resource in resource_list:
#      aggr.add_resource(resource)
#
#    # Create the resource map
#    resmap_url = cli_client.create_get_url_for_pid(mn_client_base_url, format(self.pid))
#    self.resmap = foresite.ResourceMap(resmap_url)
#    self.resmap._dcterms.identifier = self.pid
#    self.resmap.set_aggregation(aggr)
#    return self.resmap
