#!/usr/bin/env python
# -*- coding: utf-8 -*-

# This work was created by participants in the DataONE project, and is
# jointly copyrighted by participating institutions in DataONE. For
# more information on DataONE, see our web site at http://dataone.org.
#
#   Copyright ${year}
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


# TODO: This deserializes the SysMeta XML object into an ElementTree and uses
# the ElementTree to access the values and then "manually" converts them to
# native values. That process is done automatically by the autogenerated PyXB
# bindings, so it might be better to remove this whole class and refactor the
# code that uses this class to use the PyXB bindings.

'''
Module d1_client.systemmetadata
===============================

Implements a wrapper that makes it a bit simpler to pull values from
an instance of SystemMetadata.

:Created: 2010-01-11
:Author: Vieglais
:Dependencies:
  - dateutil: useful python library for parsing dates, available from
    http://labix.org/python-dateutil or easy_install python-dateutil
'''

# StdLib.
import sys
import xml.etree.ElementTree

# 3rd party.
try:
  from dateutil.parser import parse as parseDateString
except ImportError, e:
  sys.stderr.write('Import error: %s\n' % str(e))
  sys.stderr.write('Try: sudo easy_install python-dateutil\n')
  sys.stderr.write('Home: http://labix.org/python-dateutil\n')
  raise


# Local.
try:
  import d1_common.util
except ImportError as e:
  sys.stderr.write('Import error: {0}\n'.format(str(e)))
  sys.stderr.write('Try: easy_install DataONE_Common\n')
  raise


class SystemMetadata(object):
  '''Wrapper around a System Metadata entry.  Provides convenience properties
  for accessing the parsed content of the document.
  '''

  def __init__(self, xmldoc):
    ''':param xmldoc: (Unicode) The XML document to parse as System Metadata.
    '''
    self.etree = None
    self.xmldoc = xmldoc
    self._parse(xmldoc)


  def _parse(self, xmldoc):
    '''Parse the content and generate the internal "etree" which is the
    element tree instance that results from parsing.

    :param xmldoc: (Unicode) The System Metadata document to parse.
    '''
    if not isinstance(xmldoc, basestring):
      xmldoc = xmldoc.read()
    self.xmldoc = xmldoc
    self.etree = xml.etree.ElementTree.fromstring(xmldoc)


  def __repr__(self):
    return self.xmldoc


  def toXml(self, encoding='utf-8', pretty=True):
    '''Spits out representation of the parsed xml.

    :param pretty: Output is a bit easier for human digestion if True
    :rtype: (string) UTF-8 encoded string
    '''
    xml_doc = xml.etree.ElementTree.tostring(self.etree, encoding)
    if pretty:
      return d1_common.util.pretty_xml(xml_doc)
    return xml_doc


  def _getValues(self, nodeName, root=None, multiple=False):
    nodes = []
    if root is None:
      nodes = self.etree.findall(nodeName)
    else:
      nodes = root.findall(nodeName)
    if len(nodes) == 0:
      return None
    if not multiple:
      return nodes[0].text
    res = []
    for node in nodes:
      res.append(node.text)
    return res


  def __getattr__(self, name):
    '''Try and automate getting the simple properties of the schema. This works
    for elements that are simple string values.  Multiple values or things that
    require type casting need their own accessor method.

    TODO: Go through the propterties for simple string values below and see
    if they can be removed.
    '''
    #First try the inherited method
    try:
      return super(SystemMetadata, self).__getattr__(name)
    except AttributeError:
      pass
    res = self._getValues(name)
    if res is None:
      raise AttributeError("Property '%s' not found" % name)
    return res


  @property
  def pid(self):
    '''
    '''
    return self._getValues(u'identifier')


  @property
  def objectFormat(self):
    '''
    '''
    return self._getValues(u'objectFormat')


  @property
  def submitter(self):
    '''
    '''
    return self._getValues(u'submitter')


  @property
  def rightsHolder(self):
    '''
    '''
    return self._getValues(u'rightsHolder')


  # <checksum algorithm="MD5">4a8565eddcef66b2147d3aa313f3ebbb</checksum>
  @property
  def checksum(self):
    '''
    '''
    return self._getValues(u'checksum')


  @property
  def checksumAlgorithm(self):
    '''
    '''
    try:
      checksumNode = self.etree.findall(u'checksum')[0]
      return checksumNode.attrib['algorithm']
    except (IndexError, KeyError):
      raise AttributeError("Property 'checksumAlgorithm' not found")


  @property
  def dateUploaded(self):
    ''':rtype: (DateTime)
    '''
    return parseDateString(self._getValues(u'dateUploaded'))


  @property
  def dateSysMetadataModified(self):
    ''':rtype: (DateTime or None)
    '''
    try:
      return parseDateString(self._getValues(u'dateSysMetadataModified'))
    except:
      pass
    return None


  @property
  def size(self):
    ''':rtype: (integer) The reported size of the object from the sysmeta
    '''
    return int(self._getValues(sys._getframe().f_code.co_name))


  @property
  def obsoletes(self):
    ''':rtype: (list of unicode)
    '''
    return self._getValues(u'obsoletes', multiple=True)


  @property
  def obsoletedBy(self):
    ''':rtype: (list of unicode)
    '''
    return self._getValues(u'obsoletedBy', multiple=True)


  @property
  def derivedFrom(self):
    ''':rtype: (list of unicode)
    '''
    return self._getValues(u'derivedFrom', multiple=True)


  @property
  def describes(self):
    ''':rtype: (list of unicode)
    '''
    return self._getValues(u'describes', multiple=True)


  @property
  def describedBy(self):
    ''':rtype: (lsit of unicode)
    '''
    return self._getValues(u'describedBy', multiple=True)


  ## Replication properties
  @property
  def replica(self):
    ''':rtype: (list of dictionaries)  Each entry contains replica details
    '''
    result = []
    replicas = self.etree.findall(u'replica')
    for replica in replicas:
      entry = {}
      entry['replicaMemberNode'] = self._getValues(u'replicaMemberNode',
                                                   replica)
      entry['replicationStatus'] = self._getValues(u'replicationStatus',
                                                   replica)
      entry['replicaVerified'] = self._getValues(u'replicaVerified',
                                                   replica)
      entry['replicationPolicy'] = self._getValues(u'replicationPolicy',
                                                   replica)
      result.append(entry)
    return result


  ## Access control properties
  @property
  def embargoExpires(self):
    ''':rtype: (DateTime or None)
    '''
    try:
      return parseDateString(self._getValues(u'embargoExpires'))
    except:
      pass
    return None


  @property
  def accessRule(self):
    ''':rtype: (list of 3-tuple) [(type, service, subject), ... ]
    '''
    entries = self._getValues(u'accessRule', multiple=True)
    results = []
    for entry in entries:
      values = entry.split(u",")
      if len(values) == 3:
        results.append(values)
    return results
