from setuptools import setup, find_packages

import sys
sys.path.insert(0, '.')
from datautil import __version__, __doc__ as __long_description__

setup(
    name='datautil',
    version=__version__,
    license='MIT',
    description='Utilities Data Work',
    long_description=__long_description__,
    author='Open Knowledge Foundation',
    author_email='info@okfn.org',
    url='http://okfn.org/projects/datautil/',
    download_url='http://bitbucket.org/okfn/datautil/',
    install_requires=[
        'python-dateutil>=1.0',
        # (optional) for excel handling
        # xlrd
        ],
    packages=find_packages(),
    include_package_data=True,
    zip_safe=False,
    classifiers = [
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules'
    ],
)
