from models import DatabaseBind, InstanceBind

def update_bind_status(database, bind_address, bind_status):

    bind = DatabaseBind.objects.get(database= database, bind_address= bind_address)
    instances = database.infra.instances.all()
    bind_instances = InstanceBind.objects.filter(instance__in= instances,  bind_address= bind_address)

    if bind_status == 0:
        bind.delete()
        bind_instances.delete()
        return

    bind.status = bind_status
    bind.save()

    for bind_instance in bind_instances:
        bind_instance.status = bind_status
        bind_instance.save()

    return
