from models import DatabaseBind, InstanceBind, CREATED, CREATING, ERROR
import logging

logging.basicConfig()
LOG = logging.getLogger("AclBindApi")
LOG.setLevel(logging.DEBUG)

def update_bind_status(database, bind_address, bind_status):

    LOG.debug("Update {} bind {} with status {}".format(database, bind_address, bind_status))

    if bind_address == CREATING:
        bind_address = CREATED
    else:
        bind_address = ERROR

    bind = DatabaseBind.objects.get(database= database, bind_address= bind_address)
    instances = database.infra.instances.all()
    bind_instances = InstanceBind.objects.filter(instance__in= instances,  bind_address= bind_address)

    if bind_status == 0:
        bind.delete()
        bind_instances.delete()
        return

    bind.status = bind_status
    bind.save()

    for bind_instance in bind_instances:
        bind_instance.status = bind_status
        bind_instance.save()

    return
