from distutils.core import setup, Extension

setup(name="dbdreader",
      version="0.3.6",
      py_modules = ['dbdreader'],
      scripts = ['dbdrename.py','cac_gen.py'],
      ext_modules = [
          Extension("_dbdreader",
                    ["extension/py_dbdreader.c","extension/dbdreader.c"],
                    include_dirs=['extension/include'])
      ],
      author="Lucas Merckelbach",
      author_email="lucas.merckelbach@hzg.de",
      description="A python module to access binary data files generated by Teledyne WebbResearch gliders",
      long_description="Underwater gliders of the type Teledyne WebbResearch's Slocum store their data in binary files. This python module provides the classes to access these data files. It allows you to retrieve one or more parameters of a single file, or from a list of files. Methods are supplied to narrow the data range for a given time period. Using this module instead of using ascii data generated by proprietry program by the glider manufacturer results in a speed up of some three orders of magnitude.",
    url='http://dockserver0.hzg.de/software/dbdreader/index.html',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Intended Audience :: Science/Research',
        'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',
        'Operating System :: MacOS :: MacOS X',
        #          'Operating System :: Microsoft :: Windows',
        'Operating System :: POSIX',
        'Programming Language :: Python',
        'Topic :: Scientific/Engineering :: Physics',
    ])
