from setuptools import setup

setup(name='dbms',
	version='1.1.1',
	description='DataBases Made Simpler - Uniform interface for multiple adapters',
	long_description=open('README.txt').read(),
	url='https://sourceforge.net/projects/pydbms/',
	keywords='database dbms rdbms Oracle PostgreSQL MySQL SQLServer Firebird DB2 SQLite ODBC',
	classifiers=['Development Status :: 5 - Production/Stable',
    'Environment :: Console', 
    'License :: OSI Approved :: BSD License',
    'Programming Language :: Python :: 2.6',
    'Programming Language :: Python :: 2.7',
    'Programming Language :: Python :: 3',
    'Programming Language :: Python :: 3.1',
    'Programming Language :: Python :: 3.2',
    'Programming Language :: Python :: 3.3',
    'Programming Language :: Python :: 3.4',
    'Programming Language :: SQL',
    'Intended Audience :: Developers',
    'Intended Audience :: Information Technology',
    'Intended Audience :: Science/Research',
    'Topic :: Database',
    'Natural Language :: English',
    'Operating System :: OS Independent',
	],
	author='Scott Bailey',
	author_email='scottrbailey@gmail.com',
	license='LICENSE.txt',
	packages=['dbms'],
    extras_require = {
        'oracle':  ['cx_Oracle'],
        'postgres': ['psycopg2'],
        'firebird': ['fdb'],
        'mysql': ['pymssql'],
        'db2': ['ibm_db'],
        'utils': ['lxml', 'xlsxwriter', 'pandas'] 
        },
)
	
