import struct
import socket
import types

from twisted.internet import reactor, protocol, defer
from twisted.words.protocols import irc
from twisted.persisted import styles
from twisted.names import client


class IRCClient(irc.IRCClient):
    def userhost(self, user):

        user = user.lower()
        print user
        d = defer.Deferred()
        try:
            self._userhost[user] = d
        except AttributeError:
            self._userhost = {}
            self._userhost[user] = d
        self.sendLine('USERHOST {0}'.format(user))
        return d

    def irc_RPL_USERHOST(self, user, params):

        nick, _, _ = params[-1].partition('=')
        nick = nick.lower()
        print nick
        try:
            if nick in self._userhost:
                _, _, host = params[-1].partition('@')
                self._userhost[nick].callback(host)
                del self._userhost[nick]
        except AttributeError:
            pass

    @defer.inlineCallbacks
    def dccSend(self, user, file):
        if isinstance(file, types.StringType):
            file = open(file, 'r')

        size = irc.fileSize(file)

        name = getattr(file, "name", "file@%s" % (id(file),))

        interface = self.transport.getHost()

        factory = DccSendFactory(file)
        port = reactor.listenTCP(0, factory, 1, interface.host)

        address = port.getHost()

        host_from_remote = yield self.userhost(self.nickname)
        ip_from_remote = yield client.getHostByName(host_from_remote.strip())

        my_address = struct.unpack('!L', socket.inet_aton(ip_from_remote))[0]

        args = ['SEND', name, str(my_address), str(address.port)]

        if not (size is None):
            args.append(str(size))

        args = ' '.join(args)

        self.ctcpMakeQuery(user, [('DCC', args)])


class DccSendProtocol(protocol.Protocol, styles.Ephemeral):
    """Protocol for an outgoing Direct Client Connection SEND.
    """

    blocksize = 1024
    file = None
    bytesSent = 0
    completed = 0
    connected = 0

    def __init__(self, file):
        if isinstance(file, types.StringType):
            self.file = open(file, 'r')
        else:
            self.file = file

    def connectionMade(self):
	if not self.factory.used:
            self.factory.used = True
        else:
            self.transport.loseConnection()
        self.connected = 1
        self.sendBlock()

    def dataReceived(self, data):
        # XXX: Do we need to check to see if len(data) != fmtsize?

        bytesShesGot = struct.unpack("!I", data)[0]
        if bytesShesGot < self.bytesSent:
            # Wait for her.
            # XXX? Add some checks to see if we've stalled out?
            return
        elif bytesShesGot > self.bytesSent:
            # self.transport.log("DCC SEND %s: She says she has %d bytes "
            #                    "but I've only sent %d.  I'm stopping "
            #                    "this screwy transfer."
            #                    % (self.file,
            #                       bytesShesGot, self.bytesSent))
            self.transport.loseConnection()
            return

        self.sendBlock()

    def sendBlock(self):
        block = self.file.read(self.blocksize)
        if block:
            self.transport.write(block)
            self.bytesSent = self.bytesSent + len(block)
        else:
            # Nothing more to send, transfer complete.
            self.transport.loseConnection()
            self.completed = 1

    def connectionLost(self, reason):
        self.connected = 0
        if hasattr(self.file, "close"):
            self.file.close()


class DccSendFactory(protocol.Factory):
    protocol = DccSendProtocol

    def __init__(self, file):
        self.file = file
        self.used = False

    def buildProtocol(self, connection):
        p = self.protocol(self.file)
        p.factory = self
        return p
