import argparse
import os
import urllib,ast,sys
#import dictionary


def check(string):
	return string.replace("&#39","'")

def search(word):
	try:
		url="http://www.google.com/dictionary/json?callback=s&q="+word+"&sl=en&tl=en&restrict=pr,de&client=te"
		obj=urllib.urlopen(url);
	except:
		print "Please check your internet connection and try again"
		return
		
	content=obj.read()
	obj.close()	
	content=content[2:-10]
	
	dic=ast.literal_eval(content)
	if dic.has_key("webDefinitions"):
		webdef=dic["webDefinitions"]
		webdef=webdef[0]
		webdef=webdef["entries"]
		#print webdef[0]
		index=1
		index_list=["01","02","03","04","05","06","07","08","09","10"]
        final = []
        for i in webdef:
            if index==11:
                break
            final.append(str(index)+" :")
            index+=1
		
            if i["type"]=="meaning":
                ans=i["terms"]
                op=ans[0]['text']
                split=op.split(';')
                final.append(check(split[0].strip()))
                count=0
                for i in split:
                    if count!=0:
                        final.append("      "+check(i))
                    count+=1
        return final

parser = argparse.ArgumentParser(
    prog="define",
    description="Purpose: A command line dictionary",
    epilog="Developed by Luis Naranjo <luisnaranjo733@hotmail.com>"
)
parser.add_argument('words', help="Words (separate words with spaces) or filename containing words to define (split by lines)")
args = parser.parse_args().words

def parse(path):
    HOME = os.path.expanduser("~")
    temp=list(path)
    if temp[0] == "~":
        temp[0] = HOME
    return ''.join(temp)

try:
    txt = open(parse(args),'r')
    farg=True
except IOError:
    farg= False

if farg:
    data=txt.readlines()

if not farg:
    data = args.split()

def main():
    for word in data:
        print "%s --> %s\n" % (word,search(word)[1])
        print "="*72

if __name__ == "__main__":
    main()
