# -*- coding: utf-8 -*-
# test_stuffABCD.py
# This module provides the tests for the stuffABCD function.
# Copyright 2014 Giuseppe Venturini
# This file is part of python-deltasigma.
#
# python-deltasigma is a 1:1 Python replacement of Richard Schreier's 
# MATLAB delta sigma toolbox (aka "delsigma"), upon which it is heavily based.
# The delta sigma toolbox is (c) 2009, Richard Schreier.
#
# python-deltasigma is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# LICENSE file for the licensing terms.

"""This module provides the test class for the stuffABCD() function.
"""

import unittest
import numpy as np
import deltasigma as ds

from nose.tools import raises

class TestStuffABCD(unittest.TestCase):
    """Test class for stuffABCD()"""

    def setUp(self):
        # we test for the following values:
        # orders = (2, 3, 4, 5)
        # osr = 32
        # nlev = 2
        # f0s = (0., 0.25)
        # Hinf = 1.5
        # forms = ('CRFB', 'CRFF', 'CIFB', 'CIFF', 'CRFBD', 'CRFFD', 'Stratos')
        self.orders = (2, 3, 4, 5)
        self.osr = 32
        self.nlev = 2
        self.f0s = (0., 0.25)
        self.Hinf = 1.5
        self.forms = ('CRFB', 'CRFF', 'CIFB', 'CIFF', 'CRFFD', 'CRFBD', 'Stratos')
        tv = {0.:{'CIFB':{2:{'a':(0.2164, 0.7749),
                             'g':(0, ),
                             'b':(0.2164, 0.7749, 1.0000),
                             'c':(1., 1. ),
                             'ABCD':((1.0000, 0., 0.2164, -0.2164),
                                     (1.0000, 1.0000, 0.7749, -0.7749),
                                     (0, 1.0000, 1.0000, 0))
                            },
                          3:{'a':(0.0444, 0.2843, 0.8025),
                             'g':(0.0058, ),
                             'b':(0.0444, 0.2843, 0.8025, 1.),
                             'c':(1., 1., 1.),
                             'ABCD':((1.0000, 0, 0, 0.0444, -0.0444),
                                     (1.0000, 1.0000, -0.0058, 0.2843, -0.2843),
                                     (0, 1.0000, 1.0000, 0.8025, -0.8025),
                                     (0, 0, 1.0000, 1.0000, 0))
                            },
                          4:{'a':(0.0062, 0.0655, 0.3042, 0.8089),
                             'g':(0., 0.0069),
                             'b':(0.0062, 0.0655, 0.3042, 0.8089, 1.),
                             'c':(1., 1., 1., 1),
                             'ABCD':((1.0000, 0, 0, 0, 0.0062, -0.0062),
                                     (1.0000, 1.0000, 0, 0, 0.0655, -0.0655),
                                     (0, 1.0000, 1.0000, -0.0069, 0.3042, -0.3042),
                                     (0, 0, 1.0000, 1.0000, 0.8089, -0.8089),
                                     (0, 0, 0, 1.0000, 1.0000, 0))
                            },
                          5:{'a':(0.0007, 0.0095, 0.0731, 0.3100, 0.81309),
                             'g':(0.0028, 0.0079),
                             'b':(0.0007, 0.0095, 0.0731, 0.3100, 0.8130, 1.),
                             'c':(1., 1., 1., 1., 1.),
                             'ABCD':((1., 0, 0, 0, 0, 0.0007, -0.0007),
                                     (1., 1.0000, -0.0028, 0, 0, 0.0095, -0.0095),
                                     (0, 1.0000, 1.0000, 0, 0, 0.0731, -0.0731),
                                     (0, 0, 1.0000, 1.0000, -0.0079, 0.3100, -0.3100),
                                     (0, 0, 0, 1.0000, 1.0000, 0.8130, -0.8130),
                                     (0, 0, 0, 0, 1.0000, 1.0000, 0))
                            }
                         },
                  'CRFB':{2:{'a':(0.2164, 0.5585),
                             'g':(0, ),
                             'b':(0.2164, 0.5585, 1.0000),
                             'c':(1., 1. ),
                             'ABCD':((1.0000, 0., 0.2164, -0.2164),
                                     (1.0000, 1.0000, 0.7749, -0.7749),
                                     (0., 1.0, 1.0, 0))
                             },
                          3:{'a':(0.0444, 0.2399, 0.5569),
                             'g':(0.0058, ),
                             'b':(0.0444, 0.2399, 0.5569, 1.),
                             'c':(1., 1., 1.),
                             'ABCD':((1.0000, 0., 0., 0.0444, -0.0444),
                                     (1.0000, 1.0, -0.0058, 0.2399, -0.2399),
                                     (1.0000, 1.0,  0.9942, 0.7967, -0.7967),
                                     (0.,     0.,   1.0000, 1.0000,  0.))
                            },
                          4:{'a':(0.0062, 0.0530, 0.2449, 0.5571),
                             'g':(0, 0.0069),
                             'b':(0.0062, 0.0530, 0.2449, 0.5571, 1.),
                             'c':(1., 1., 1., 1),
                             'ABCD':((1., 0., 0.,  0., 0.0062, -0.0062),
                                     (1., 1., 0.,  0., 0.0592, -0.0592),
                                     (0., 1., 1., -0.0069, 0.2449, -0.2449),
                                     (0., 1., 1.,  0.9931, 0.8020, -0.8020),
                                     (0., 0., 0.,  1.0000, 1.0000,  0.))
                             },
                          5:{'a':(0.0007, 0.0084, 0.0550, 0.2443, 0.5579),
                             'g':(0.0028, 0.0079),
                             'b':(0.0007, 0.0084, 0.0550, 0.2443, 0.5579, 1.),
                             'c':(1., 1., 1., 1., 1.),
                             'ABCD':((1., 0.,  0.,     0., 0., 0.0007, -0.0007),
                                     (1., 1., -0.0028, 0., 0., 0.0084, -0.0084),
                                     (1., 1.,  0.9972, 0., 0., 0.0633, -0.0633),
                                     (0., 0.,  1.0000, 1., -0.0079, 0.2443, -0.2443),
                                     (0., 0.,  1.0000, 1.,  0.9921, 0.8023, -0.8023),
                                     (0., 0.,  0.,     0.,  1.0000, 1.0000,  0.))
                             }
                          },
                  'CRFF':{2:{'a':(0.5585, 0.2164),
                             'g':(0, ),
                             'b':(1., 0., 1.),
                             'c':(1., 1. ),
                             'ABCD':((1., 0., 1., -1.),
                                     (1., 1., 0.,  0.),
                                     (0.7749, 0.2164, 1., 0.))
                             },
                          3:{'a':(0.5569, 0.2399, 0.0412),
                             'g':(0.0058, ),
                             'b':(1., 0., 0., 1.),
                             'c':(1., 1., 1.),
                             'ABCD':((1., 0.,  0., 1., -1.),
                                     (1., 1.,  -0.0058, 0., 0.),
                                     (1., 1.,   0.9942, 0., 0.),
                                     (0.7967, 0.2399, 0.0398, 1.0000, 0.))
                             },
                          4:{'a':(0.5571, 0.2449, 0.0492, 0.0046),
                             'g':(0, 0.0069),
                             'b':(1., 0., 0., 0., 1.),
                             'c':(1., 1., 1., 1),
                             'ABCD':((1., 0., 0, 0, 1.0000, -1.0000),
                                     (1.0000, 1.0000, 0, 0, 0, 0),
                                     (1.0000, 1.0000, 0.9931, -0.0069, 0, 0),
                                     (0, 0, 1.0000, 1.0000, 0, 0),
                                     (0.8020, 0.2449, 0.0537, 0.0046, 1.0000, 0))
                             },
                          5:{'a':(0.5579, 0.2443, 0.0505, 0.0071, 0.0003),
                             'g':(0.0028, 0.0079),
                             'b':(1., 0., 0., 0., 0., 1.),
                             'c':(1., 1., 1., 1., 1.),
                             'ABCD':((1.0000, 0, 0, 0, 0, 1.0000, -1.0000),
                                     (1.0000, 1.0000, -0.0028, 0, 0, 0, 0),
                                     (1.0000, 1.0000, 0.9972,  0, 0, 0, 0),
                                     (0, 0, 1.0000, 1.0000, -0.0079, 0, 0),
                                     (0, 0, 1.0000, 1.0000,  0.9921, 0, 0),
                                     (0.8023, 0.2443, 0.0570, 0.0071, 0.0002, 1., 0))
                             }
                          },
                  'CIFF':{2:{'a':(0.7749, 0.2164),
                             'g':(0., ),
                             'b':(1., 0., 1.),
                             'c':(1., 1. ),
                             'ABCD':((1.0000, 0, 1.0000, -1.0000),
                                     (1.0000, 1.0000, 0,  0),
                                     (0.7749, 0.2164, 1.0000, 0))
                             },
                          3:{'a':(0.8025, 0.2843, 0.0398),
                             'g':(0.0058, ),
                             'b':(1., 0., 0., 1.),
                             'c':(1., 1., 1.),
                             'ABCD':((1.0000, 0, 0, 1.0000, -1.0000),
                                     (1.0000, 1.0000, -0.0058, 0, 0),
                                     (0, 1.0000, 1.0000, 0, 0),
                                     (0.8025, 0.2843, 0.0398, 1.0000, 0))
                             },
                          4:{'a':(0.8089, 0.3042, 0.0599, 0.0041),
                             'g':(0., 0.0069),
                             'b':(1., 0., 0., 0., 1.),
                             'c':(1., 1., 1., 1),
                             'ABCD':((1.0000, 0, 0, 0, 1.0000, -1.0000),
                                     (1.0000, 1.0000, 0, 0, 0, 0),
                                     (0, 1.0000, 1.0000, -0.0069, 0, 0),
                                     (0, 0, 1.0000, 1.0000, 0, 0),
                                     (0.8089, 0.3042, 0.0599, 0.0041, 1.0000, 0))
                             },
                          5:{'a':(0.8130, 0.3100, 0.0667, 0.0080, 0.0001),
                             'g':(0.0028, 0.0079),
                             'b':(1., 0., 0., 0., 0., 1.),
                             'c':(1., 1., 1., 1., 1.),
                             'ABCD':((1.0000, 0, 0, 0, 0, 1.0000, -1.0000),
                                     (1.0000, 1.0000, -0.0028, 0, 0, 0, 0),
                                     (0, 1.0000, 1.0000, 0, 0, 0, 0),
                                     (0, 0., 1.0000, 1.0000, -0.0079, 0, 0),
                                     (0, 0., 0, 1.0000, 1.0000, 0, 0),
                                     (0.8130, 0.3100, 0.0667, 0.0080, 0.0001,  1., 0))
                             }
                          },
                  'CRFBD':{2:{'a':(0.2164, 0.7749),
                              'g':(0, ),
                              'b':(0.2164, 0.7749, 1.),
                              'c':(1., 1. ),
                              'ABCD':((1.0000, 0, 0.2164, -0.2164),
                                      (1.0000, 1.0000, 0.7749, -0.7749),
                                      (0, 1.0000, 1.0000, 0))
                              },
                           3:{'a':(0.0444, 0.2399, 0.7967),
                              'g':(0.0058, ),
                              'b':(0.0444, 0.2399, 0.7967, 1.),
                              'c':(1., 1., 1.),
                              'ABCD':((1.0000, 0, 0, 0.0444, -0.0444),
                                      (1.0000, 0.9942, -0.0058, 0.2796, -0.2796),
                                      (0, 1.0000, 1.0000, 0.7967, -0.7967),
                                      (0, 0, 1.0000, 1.0000, 0))
                              },
                           4:{'a':(0.0062, 0.0592, 0.2449, 0.8020),
                              'g':(0, 0.0069),
                              'b':(0.0062, 0.0592, 0.2449, 0.8020, 1.),
                              'c':(1., 1., 1., 1),
                              'ABCD':((1.0000, 0, 0, 0, 0.0062, -0.0062),
                                      (1.0000, 1.0000, 0, 0, 0.0592, -0.0592),
                                      (1.0000, 1.0000, 0.9931, -0.0069, 0.2987, -0.2987),
                                      (0, 0, 1.0000, 1.0000, 0.8020, -0.8020),
                                      (0, 0, 0, 1.0000, 1.0000, 0))
                              },
                           5:{'a':(0.0007, 0.0084, 0.0633, 0.2443, 0.8023),
                              'g':(0.0028, 0.0079),
                              'b':(0.0007, 0.0084, 0.0633, 0.2443, 0.8023, 1.),
                              'c':(1., 1., 1., 1., 1.),
                              'ABCD':((1.0000, 0, 0, 0, 0, 0.0007, -0.0007),
                                      (1.0000, 0.9972, -0.0028, 0, 0, 0.0089, -0.0089),
                                      (0, 1.0000, 1.0000, 0, 0, 0.0633, -0.0633),
                                      (0, 1., 1., 0.9921, -0.0079, 0.3013, -0.3013),
                                      (0, 0,  0,  1.0000,  1.0000, 0.8023,  -0.8023),
                                      (0, 0,  0,  0, 1.0000, 1.0000, 0))
                             }
                           },
                  'CRFFD':{2:{'a':(0.7749, 0.2164),
                              'g':(0.),
                              'b':(1., 0., 1.),
                              'c':(1., 1.),
                              'ABCD':((1., -0., 0., 1., -1.),
                                      (1.,  1., 0., 1., -1.),
                                      (0.7749, 0.2164, 0., 1.7749, -0.7749),
                                      (0., 0., 1., 0., 0.))
                             },
                           3:{'a':(0.7967, 0.2399, 0.0398),
                              'g':(0.0058),
                              'b':(1., 0., 0., 1.),
                              'c':(1., 1., 1.),
                              'ABCD':((1., 0. , 0., 0., 1., -1.),
                                      (1., 0.9942, -0.0058, 0., 1., -1.),
                                      (0., 1., 1., 0., 0., 0.),
                                      (0.7967, 0.2797, 0.0398, 0., 1.7967, -0.7967),
                                      (0., 0., 0., 1., 0., 0.))
                             },
                           4:{'a':(0.8020, 0.2449, 0.0537, 0.0046),
                              'g':(0., 0.0069),
                              'b':(1., 0., 0., 0., 1.),
                              'c':(1., 1., 1., 1.),
                              'ABCD':((1., -0., 0., 0., 0., 1., -1.),
                                      (1., 1., 0., 0., 0., 1., -1.),
                                      (0., 1., 1., -0.0069, 0., 0., 0.),
                                      (0., 1., 1., 0.9931, 0., 0., 0.),
                                      (0.802, 0.2986, 0.0537, 0.00422947, 0., 1.802, -0.802),
                                      (0., 0., 0., 0., 1., 0., 0.))
                             },
                           5:{'a':(0.8023, 0.2443, 0.0570, 0.0071, 0.0002),
                              'g':(0.0028, 0.0079),
                              'b':(1., 0., 0., 0., 0., 1.),
                              'c':(1., 1., 1., 1., 1.),
                              'ABCD':((1., 0., 0., 0., 0., 0., 1.,  -1.),
                                      (1., 9.972e-01, -2.8e-03, 0., 0., 0., 1., -1.),
                                      (0., 1., 1., 0., 0., 0., 0., 0.),
                                      (0., 1., 1., 9.921e-01, -7.9e-03, 0., 0., 0.),
                                      (0., 0., 0., 1., 1., 0., 0., 0.),
                                      (8.023e-01, 3.013e-01, 5.7e-02, 7.3e-03, 2.0e-04, 0., 1.8023, -8.023e-01),
                                      (0., 0., 0., 0., 0., 1., 0., 0.))
                             }
                          },
                  'Stratos':{2:{'a':(0.7749, 0.2164),
                                'g':(0, ),
                                'b':(1, 0., 1.),
                                'c':(1., 1. ),
                                'ABCD':((1.0000, 0, 1.0000, -1.0000),
                                        (1.0000, 1.0000, 0, 0),
                                        (0.7749, 0.2164, 1.0000, 0))
                                },
                             3:{'a':(0.7967, 0.2796, 0.0398),
                                'g':(0.0058, ),
                                'b':(1., 0., 0., 1.),
                                'c':(1., 1., 1.),
                                'ABCD':((1.0000, 0, 0, 1.0000, -1.0000),
                                        (1.0000, 0.9942, -0.0058, 0, 0),
                                        (0, 1.0000, 1.0000, 0, 0),
                                        (0.7967, 0.2796, 0.0398, 1.0000, 0))
                                },
                             4:{'a':(0.8020, 0.2987, 0.0579, 0.0042),
                                'g':(0, 0.0069),
                                'b':(1., 0., 0., 0., 1.),
                                'c':(1., 1., 1., 1),
                                'ABCD':((1.0000, 0, 0, 0, 1.0000, -1.0000),
                                        (1.0000, 1.0000, 0, 0, 0, 0),
                                        (0, 1.0000, 0.9931, -0.0069, 0, 0),
                                        (0, 0, 1.0000, 1.0000, 0, 0),
                                        (0.8020, 0.2987, 0.0579, 0.0042, 1.0000, 0))
                                },
                             5:{'a':(0.8023, 0.3013, 0.0643, 0.0075, 0.0001),
                                'g':(0.0028, 0.0079),
                                'b':(1., 0., 0., 0., 0., 1.),
                                'c':(1., 1., 1., 1., 1.),
                                'ABCD':((1., 0, 0, 0, 0, 1.0000, -1.0000),
                                        (1.0000, 0.9972, -0.0028, 0, 0, 0, 0),
                                        (0, 1.0000, 1.0000, 0, 0, 0, 0),
                                        (0, 0, 1.0000, 0.9921, -0.0079, 0, 0),
                                        (0, 0, 0, 1.0000, 1.0000, 0, 0),
                                        (0.8023, 0.3013, 0.0643, 0.0075, 0.0001, 1., 0))
                                }
                             }
                 },
              0.25:{'CIFB':{2:{'a':(0.3333, 2.0000),
                               'g':(1., ),
                               'b':(0.3333, 2., 1.0000),
                               'c':(1., 1. ),
                               'ABCD':((1.0000, -1.0000, 0.3333, -0.3333),
                                       (1.0000,  1.0000, 2.0000, -2.0000),
                                       (0.,      1.0000, 1.0000,  0.))
                               },
                            4:{'a':(-3.5585, 2.4503, 5.22512, 4.0000),
                               'g':(1., 1.),
                               'b':(-3.5585, 2.4503, 5.22512, 4.0000, 1.),
                               'c':(1., 1., 1., 1),
                               'ABCD':((1.0000, -1.0000, 0, 0, -3.5585,  3.5585),
                                       (1.0000,  1.0000, 0, 0,  2.4503, -2.4503),
                                       (0, 1.0000, 1.0000, -1.0000, 5.2251, -5.2251),
                                       (0, 0, 1.0000, 1.0000, 4.0000, -4.0000),
                                       (0, 0, 0, 1.0000, 1.0000, 0))
                               }
                            },
                    'CRFB':{2:{'a':(-0.6667, 0.6667),
                               'g':(2.0, ),
                               'b':(-0.6667, 0.6667, 1.0000),
                               'c':(1., 1. ),
                               'ABCD':((1.0000, -2.0000, -0.6667, 0.6667),
                                       (1.0000, -1.0000, -0.0000, 0.0000),
                                        (0., 1.0000, 1.0000, 0.))
                               },
                            4:{'a':(-0.2164, 0., -0.5585, 0.5585),
                               'g':(2.0, 2.0),
                               'b':(-0.2164, 0.0, -0.5585, 0.5585, 1.),
                               'c':(1., 1., 1., 1),
                               'ABCD':((1., -2., 0, 0, -0.2164, 0.2164),
                                       (1., -1., 0, 0, -0.2164, 0.2164),
                                       (0., 1., 1., -2., -0.5585, 0.5585),
                                       (0, 1., 1., -1., 0., 0.),
                                       (0., 0., 0., 1., 1., 0.))
                               }
                            },
                    'CRFF':{2:{'a':(0.6667, -0.6667),
                               'g':(2.0, ),
                               'b':(1., 0., 1.),
                               'c':(1., 1. ),
                               'ABCD':((-1., -2., 1., -1.),
                                       (1., 1., 0., 0.),
                                       (0., -0.6667, 1., 0))
                               },
                            4:{'a':(0.5585, -0.5585, 0., -0.2164),
                               'g':(2., 2.),
                               'b':(1., 0., 0., 0., 1.),
                               'c':(1., 1., 1., 1),
                               'ABCD':((-1., -2., 0., 0., 1., -1.),
                                       ( 1., 1., 0., 0., 0., 0.),
                                       (1., 1., -1., -2., 0., 0.),
                                       (0., 0., 1., 1., 0., 0.),
                                       (0., -0.5585, -0.2164, -0.2164, 1., 0.))
                               }
                            },
                    'CIFF':{2:{'a':(2., 0.3333),
                               'g':(1., ),
                               'b':(1., 0., 1.),
                               'c':(1., 1. ),
                               'ABCD':((1., -1., 1., -1.),
                                       (1., 1., 0., 0.),
                                       (2., 0.3333, 1., 0.))
                               },
                            4:{'a':(4., 5.2251, 2.4503, -3.5585),
                               'g':(1., 1.),
                               'b':(1., 0., 0., 0., 1.),
                               'c':(1., 1., 1., 1),
                               'ABCD':((1., -1., 0., 0., 1., -1.),
                                       (1.,  1., 0., 0., 0., 0.),
                                       (0.,  1., 1., -1., 0., 0),
                                       (0., 0., 1., 1., 0., 0),
                                       (4., 5.2251, 2.4503, -3.5585, 1., 0.))
                               }
                            },
                    'CRFBD':{2:{'a':(-0.6667, 0.),
                                'g':(2.0, ),
                                'b':(-0.6667, 0., 1.),
                                'c':(1., 1. ),
                                'ABCD':((-1.0000, -2.0000, -0.6667, 0.6667),
                                        (1.0000, 1.0000, -0.0000, 0.0000),
                                        (0., 1.0000, 1.0000, 0.))
                                },
                             4:{'a':(-0.2164, -0.2164, -0.5585, 0.),
                                'g':(2., 2.),
                                'b':(-0.2164, -0.2164, -0.5585, 0., 1.),
                                'c':(1., 1., 1., 1),
                                'ABCD':((-1.0000, -2.0000, 0, 0, 0.2164, -0.2164),
                                        (1.0000, 1.0000, 0, 0, -0.2164, 0.2164),
                                        (1., 1., -1., -2.0000, -0.7749, 0.7749),
                                        (0., 0., 1., 1., 0., 0.),
                                        (0., 0., 0., 1., 1., 0.))
                               }
                             },
                   'CRFFD':{2:{'a':(-1.2149e-15, -0.6667),
                               'g':(2.),
                               'b':(1., 0., 1.),
                               'c':(1., 1.),
                               'ABCD':((1., -2., 0., 1., -1.),
                                       (1., -1., 0., 1., -1.),
                                       (0., -6.667e-01, 0., 1., 0.),
                                       (0., 0., 1., 0., 0.))
                              },
                            4:{'a':(0.0000, -0.5585, -0.2164, -0.2164),
                               'g':(2., 2.),
                               'b':(1., 0., 0., 0., 1.),
                               'c':(1., 1., 1., 1.),
                               'ABCD':((1., -2., 0., 0., 0., 1., -1.),
                                       (1., -1., 0., 0., 0., 1., -1.),
                                       (0., 1., 1., -2., 0., 0., 0.),
                                       (0., 1., 1., -1., 0., 0., 0.),
                                       (0., -0.7749, -0.2164, 0.2164, 0., 1., 0.),
                                       (0., 0., 0., 0., 1., 0., 0.))
                              }
                           },
                   'Stratos':{2:{'a':(0., -0.6667),
                              'g':(2., ),
                              'b':(1, 0., 1.),
                              'c':(1., 1. ),
                              'ABCD':((-1., -2., 1., -1.),
                                      (1., 1., 0., 0.),
                                      (-0., -0.6667, 1., 0.))
                              },
                           4:{'a':(0., -0.7749, 0., 0.2164),
                              'g':(2.0, 2.0),
                              'b':(1., 0., 0., 0., 1.),
                              'c':(1., 1., 1., 1),
                              'ABCD':((-1., -2., 0., 0., 1., -1.),
                                      (1., 1., 0., 0., 0., 0.),
                                      (0., 1., -1., -2., 0., 0.),
                                      (0., 0., 1., 1., 0., 0.),
                                      (0., -0.7749, 0., 0.2164, 1., 0.))
                              }
                           }
                }
             }
        self.tv = tv

    def test_stuffABCD(self):
        """Test function for stuffABCD() 1/3"""
        for f0 in self.tv:
            for form in self.tv[f0]:
                for order in self.tv[f0][form]:
                    # Optimized zero placement
                    print("Testing form: %s, order: %d, f0: %f" % \
                          (form, order, f0))
                    a = np.array(self.tv[f0][form][order]['a']).reshape((1, -1))
                    g = np.array(self.tv[f0][form][order]['g']).reshape((1, -1))
                    b = np.array(self.tv[f0][form][order]['b']).reshape((1, -1))
                    c = np.array(self.tv[f0][form][order]['c']).reshape((1, -1))
                    ABCD = ds.stuffABCD(a, g, b, c, form)
                    print(repr(ABCD))
                    self.assertTrue(np.allclose(ABCD, self.tv[f0][form][order]['ABCD'],
                                    atol=1e-4, rtol=1e-3))

    @raises(ValueError)
    def test_stuffABCD_2(self):
        """Test function for stuffABCD() 2/2"""
        ds.stuffABCD((0.2164, 0.7749), (0, ), (0.2164, 0.7749, 1.), (1., 1. ), 'DUMMY')

