#!/usr/bin/env python

import os
import zipfile

from distutils.core import setup

zf = zipfile.ZipFile(os.path.join('deploytk', 'skel.zip'), 'w')

for base,directories,filenames in os.walk('skel'):
    for filename in filenames:
        path = os.path.join(base, filename)
        zf.write(path, path[5:])

zf.close()

setup(
    name = 'deploytk',
    version = '0.1.0',
    author = 'Matthew Oertle',
    author_email = 'moertle@gmail.com',
    packages = [
        'deploytk',
        ],
    package_data = {
        'deploytk': ['skel.zip']
        },
    url = 'https://github.com/moertle/deploy.tk',
    license  = 'BSD',
    description = 'A framework for distributed job management',
    long_description = open('README.md').read(),
    install_requires = [
        'pyaas >= 0.1.5',
	'pyzmq >= 14.0.1',
    ],
    zip_safe = False
)
