

    Navbar = Backbone.View.extend
        el: $('#main_navbar')

        events:
            'click .navclick' : 'OnNavClick'

        OnNavClick: (event) ->
            console.log('Nav click:', event.target)

    Router = Backbone.Router.extend
        routes:
            'job/new/:system' : 'job_new'
            'logout'          : 'logout'
            ''                : 'main'

        initialize: () ->
            @modal = $('#modal')
            return

        main: () ->

        logout: () ->
            window.location = '/logout'
            return

        job_new: (system) ->
            @jobDialogBox.close() if @jobDialogBox?.$el

            console.info('MODEL:', deploy.foremen.get(system))

            @jobDialogBox = new JobDialogBox
                model: deploy.foremen.get(system)
                template: templates.job_menu
                title: "New Job - #{system}"

            window.location.replace('#')
            return

    JobDialogBox = DialogBox.extend
        events:
            'submit #add_job' : 'OnAddJob'

        initialize: (options) ->
            DialogBox.prototype.initialize.call(@, options)
            _.bindAll @, 'OnAddJob'

        OnAddJob: (event) ->
            console.log('Create Job:', @$('#program').val(), @$('#arguments').val())

            deploy.jobs.create
                foreman:   @model.id
                program:   @$('#program').val()
                arguments: @$('#arguments').val()
              ,
                wait: true
                success: (model, response, options) =>
                    @close()
                    return

            cancelEvent(event)
