// Generated by CoffeeScript 1.7.1
(function() {
  var ContextMenu, Deploy, DialogBox, Foreman, ForemanGroup, ForemanListEntry, Foremen, ForemenListView, GraphView, Job, JobDialogBox, JobNode, Jobs, JobsTableView, Link, Links, Manager, Managers, Navbar, Position, Positions, Router, deploy, dialog, templates;

  dialog = {
    resizable: false,
    width: 0,
    minWidth: 200,
    minHeight: 0,
    modal: false
  };

  templates = {};

  $(document).ready(function() {
    $('script[type="text/html-template"]').each(function() {
      templates[this.id] = _.template(this.text);
    });
    $(document).on('dragover', function(event) {
      if (event.preventDefault) {
        event.preventDefault();
      }
      return false;
    });
    $(document).on('drop', function(event) {
      if (event.preventDefault) {
        event.preventDefault();
      }
    });
    $(document).on('keyup', function(event) {
      if (event.keyCode === 27) {
        return $('.contextMenu').remove();
      }
    });
  });

  Job = Backbone.Model.extend({
    url: '/jobs/'
  });

  Jobs = Backbone.Collection.extend({
    model: Job
  });

  Foreman = Backbone.Model.extend({
    url: '/foremen/'
  });

  Foremen = Backbone.Collection.extend({
    model: Foreman
  });

  Manager = Backbone.Model.extend({
    url: '/managers/'
  });

  Managers = Backbone.Collection.extend({
    model: Manager
  });

  Link = Backbone.Model.extend({
    urlRoot: '/links/'
  });

  Links = Backbone.Collection.extend({
    model: Link
  });

  Position = Backbone.Model.extend({
    urlRoot: '/positions/'
  });

  Positions = Backbone.Collection.extend({
    model: Position
  });

  ContextMenu = Backbone.View.extend({
    attributes: {
      "class": 'contextMenu dropdown clearfix'
    },
    events: {
      'click a': 'OnClick'
    },
    initialize: function(options) {
      this.$el.html(options.template(options.json));
      this.$el.css({
        left: options.x,
        top: options.y
      }).appendTo($(document.body));
      return this;
    },
    OnClick: function(event) {
      return this.remove();
    }
  });

  DialogBox = Backbone.View.extend({
    attributes: {
      "class": 'dialogBox'
    },
    initialize: function(options) {
      var $body, $titleBar;
      _.bindAll(this, 'close', 'OnMouseDown', 'OnMouseMove', 'OnMouseUp', 'OnKeyUp');
      $titleBar = $('<div class="titlebar">' + options.title + '<span class="glyphicon glyphicon-remove-sign"></span></div>');
      $body = $('<div class="body">Body</div>');
      this.$el.append($titleBar).append($body).appendTo($(document.body));
      this.$('div.body').html(options.template(options.json));
      this.$el.css({
        left: options.x || (window.innerWidth - this.$el.width()) / 2,
        top: options.y || (window.innerHeight - this.$el.height()) / 2
      });
      $titleBar.find('span').on('click', this.close);
      $titleBar.on('mousedown.dialogBox', this.OnMouseDown);
      $(document).on('mousemove.dialogBox', this.OnMouseMove);
      $(document).on('mouseup.dialogBox', this.OnMouseUp);
      return $(document).on('keyup.dialogBox', this.OnKeyUp);
    },
    close: function(event) {
      this.undelegateEvents();
      this.$el.removeData().unbind();
      this.remove();
      Backbone.View.prototype.remove.call(this);
      $(document).off('.dialogBox');
    },
    OnMouseDown: function(event) {
      if (event.shiftKey) {
        return;
      }
      this.drag = this.$el.offset();
      this.drag.x = event.screenX;
      this.drag.y = event.screenY;
      return cancelEvent(event);
    },
    OnMouseMove: function(event) {
      var x, y;
      if (!this.drag) {
        return;
      }
      x = this.drag.left - this.drag.x + event.screenX;
      y = this.drag.top - this.drag.y + event.screenY;
      this.$el.offset({
        top: y,
        left: x
      });
      return cancelEvent(event);
    },
    OnMouseUp: function(event) {
      this.drag = null;
    },
    OnKeyUp: function(event) {
      if (event.keyCode === 27) {
        return this.close();
      }
    }
  });

  deploy = null;

  $(document).ready(function() {
    new Deploy();
    new Router();
    Backbone.history.start();
  });

  Deploy = (function() {
    function Deploy() {
      var nv;
      if (deploy == null) {
        deploy = this;
      }
      window._deploy = deploy;
      nv = new Navbar;
      this.jobsTables = {};
      this.foremen = new Foremen;
      this.jobs = new Jobs;
      this.positions = new Positions;
      this.dispatch = _.clone(Backbone.Events);
      this.dispatch.on('CreateForeman', function(msg) {
        deploy.foremen.add(msg);
      });
      this.dispatch.on('UpdateForeman', function(msg) {
        deploy.foremen.add(msg, {
          merge: true
        });
      });
      this.dispatch.on('DeleteForeman', function(msg) {
        deploy.foremen.remove(msg.id);
      });
      this.dispatch.on('UpdateForemanText', function(msg) {
        var model;
        model = this.foremen.get(msg.id);
        console.log('>>>', model, msg.text);
        model.foreman.dom.status.text(msg.text);
      });
      this.dispatch.on('CreateManager', function(msg) {
        deploy.managers.add(msg);
      });
      this.dispatch.on('UpdateManager', function(msg) {
        deploy.managers.add(msg, {
          merge: true
        });
      });
      this.dispatch.on('DeleteManager', function(msg) {
        deploy.managers.remove(msg.id);
      });
      this.dispatch.on('CreateJob', function(msg) {
        console.log('CreateJob', msg);
        deploy.jobs.add(msg);
      });
      this.dispatch.on('UpdateJob', function(msg) {
        deploy.jobs.add(msg, {
          merge: true
        });
      });
      this.dispatch.on('DeleteJob', function(msg) {
        deploy.jobs.remove(msg.id);
      });
      this.dispatch.on('CreatePosition', function(msg) {
        deploy.positions.add(msg);
      });
      this.dispatch.on('UpdatePosition', function(msg) {
        var position;
        position = deploy.positions.get(msg.id);
        if (position) {
          position.set({
            'x': msg.x,
            'y': msg.y
          });
        } else {
          console.warn('Position not available');
        }
      });
      this.dispatch.on('UpdateArc', function(msg) {
        var arc;
        arc = deploy.arcs.get(msg._id);
        if (arc) {
          arc.set('arc', msg.arc);
        } else {
          console.warn('Arc not available');
        }
      });
      this.graph = new GraphView({
        el: $('#surface svg')
      });
      this.foremenListView = new ForemenListView;
      this.positions.reset(_data.positions);
      this.foremen.reset(_data.foremen);
      this.jobs.reset(_data.jobs);
      this.WebsocketConnect();
      return;
    }

    Deploy.prototype.WebsocketConnect = function() {
      var protocol;
      if (this.timeout == null) {
        this.timeout = 0.9375;
      }
      protocol = location.protocol.replace('http', 'ws');
      this.ws = new WebSocket("" + protocol + "://" + location.host + "/ws");
      this.ws.onopen = (function(_this) {
        return function(event) {
          _this.timeout = 0.9375;
          _this.interval = setInterval(function() {
            _this.ws.send('ping');
          }, 1000 * 60);
        };
      })(this);
      this.ws.onmessage = (function(_this) {
        return function(event) {
          var msg;
          msg = JSON.parse(event.data);
          _this.dispatch.trigger(msg.action, msg.data);
        };
      })(this);
      this.ws.onerror = (function(_this) {
        return function(event) {
          clearInterval(_this.interval);
          _this.timeout = _this.timeout * 2;
        };
      })(this);
      this.ws.onclose = (function(_this) {
        return function(event) {
          clearInterval(_this.interval);
          if (_this.timeout > 60) {
            console.warn('Unable to reconnect to server, giving up.');
            alert('Lost connection to the server');
            return;
          }
          console.info('Connection closed, reconnecting in', Math.round(_this.timeout));
          setTimeout(function() {
            _this.WebsocketConnect();
          }, 1000 * _this.timeout);
        };
      })(this);
    };

    return Deploy;

  })();

  Navbar = Backbone.View.extend({
    el: $('#main_navbar'),
    events: {
      'click .navclick': 'OnNavClick'
    },
    OnNavClick: function(event) {
      return console.log('Nav click:', event.target);
    }
  });

  Router = Backbone.Router.extend({
    routes: {
      'job/new/:system': 'job_new',
      'logout': 'logout',
      '': 'main'
    },
    initialize: function() {
      this.modal = $('#modal');
    },
    main: function() {},
    logout: function() {
      window.location = '/logout';
    },
    job_new: function(system) {
      var _ref;
      if ((_ref = this.jobDialogBox) != null ? _ref.$el : void 0) {
        this.jobDialogBox.close();
      }
      console.info('MODEL:', deploy.foremen.get(system));
      this.jobDialogBox = new JobDialogBox({
        model: deploy.foremen.get(system),
        template: templates.job_menu,
        title: "New Job - " + system
      });
      window.location.replace('#');
    }
  });

  JobDialogBox = DialogBox.extend({
    events: {
      'submit #add_job': 'OnAddJob'
    },
    initialize: function(options) {
      DialogBox.prototype.initialize.call(this, options);
      return _.bindAll(this, 'OnAddJob');
    },
    OnAddJob: function(event) {
      console.log('Create Job:', this.$('#program').val(), this.$('#arguments').val());
      deploy.jobs.create({
        foreman: this.model.id,
        program: this.$('#program').val(),
        "arguments": this.$('#arguments').val()
      }, {
        wait: true,
        success: (function(_this) {
          return function(model, response, options) {
            _this.close();
          };
        })(this)
      });
      return cancelEvent(event);
    }
  });

  GraphView = Avispa.extend({
    secondstage: function() {
      deploy.foremen.bind('add', this.AddForeman, this);
      deploy.foremen.bind('reset', (function(_this) {
        return function(foremen) {
          foremen.each(function(foreman) {
            _this.AddForeman(foreman);
          });
        };
      })(this));
      deploy.jobs.bind('add', this.AddJob, this);
      deploy.jobs.bind('reset', (function(_this) {
        return function(jobs) {
          jobs.each(function(job) {
            _this.AddJob(job);
          });
        };
      })(this));
      return this;
    },
    AddForeman: function(foreman) {
      var view;
      view = new ForemanGroup({
        model: foreman,
        position: deploy.positions.get(foreman.id),
        parent: null
      });
      this.$groups.append(view.$el);
    },
    AddJob: function(job) {
      var foreman, p, view;
      foreman = deploy.foremen.get(job.get('foreman'));
      p = new Position({
        x: 30,
        y: 50,
        radius: 20,
        fill: '#fcc'
      });
      view = new JobNode({
        model: job,
        position: p,
        parent: foreman.foremanGroup,
        label: job.get('program')
      });
      this.$objects.append(view.$el);
    },
    OnMouseDown: function(event) {
      $('.contextMenu').hide();
      return Avispa.prototype.OnMouseDown.call(this, event);
    },
    OnContextMenu: function(event) {
      if (event.shiftKey) {
        return;
      }
      console.debug('TODO: display context menu');
      return cancelEvent(event);
    }
  });

  ForemanGroup = Avispa.Group.extend({
    init: function() {
      this.model.foremanGroup = this;
      this.$label = $SVG('text').attr('dx', '0.5em').attr('dy', '1.5em').text(this.model.get('id')).appendTo(this.$el);
      return this;
    },
    render: function() {
      this.$rect.attr('x', this.position.get('x')).attr('y', this.position.get('y'));
      this.$label.attr('x', this.position.get('x')).attr('y', this.position.get('y'));
      return this;
    },
    Drag: function(event) {
      var msg;
      Avispa.Group.prototype.Drag.call(this, event);
      msg = {
        action: 'UpdatePosition',
        data: this.position.toJSON()
      };
      deploy.ws.send(JSON.stringify(msg));
      return false;
    },
    OnMouseDown: function(event) {
      $('.contextMenu').hide();
      return Avispa.Group.prototype.OnMouseDown.call(this, event);
    },
    OnMouseUp: function(event) {
      this.position.save();
    },
    OnContextMenu: function(event) {
      var menu;
      if (event.shiftKey) {
        return;
      }
      cancelEvent(event);
      menu = new ContextMenu({
        template: templates.foreman_menu,
        json: this.model.toJSON(),
        x: event.pageX + 1,
        y: event.pageY + 1
      });
      return false;
    }
  });

  JobNode = Avispa.Node.extend({
    Drag: function(event) {
      Avispa.Node.prototype.Drag.call(this, event);
      return false;
    },
    OnMouseDown: function(event) {
      $('.contextMenu').hide();
      return Avispa.Node.prototype.OnMouseDown.call(this, event);
    }
  });

  ForemenListView = Backbone.View.extend({
    el: '#foremen_list',
    events: {
      'click b': 'OnCollapse'
    },
    initialize: function() {
      _.bindAll(this, 'OnCollapse');
      deploy.foremen.bind('add', this.AddForeman, this);
      deploy.foremen.bind('reset', (function(_this) {
        return function(foremen) {
          foremen.each(function(foreman) {
            _this.AddForeman(foreman);
          });
        };
      })(this));
      deploy.jobs.bind('add', this.AddJob, this);
      deploy.jobs.bind('reset', (function(_this) {
        return function(jobs) {
          jobs.each(function(job) {
            _this.AddJob(job);
          });
        };
      })(this));
      return this;
    },
    AddForeman: function(foreman) {
      var view;
      view = new ForemanListEntry({
        model: foreman
      });
      this.$el.append(view.$el);
    },
    AddJob: function(job) {
      var jobsTable;
      jobsTable = deploy.jobsTables[job.get('foreman')];
      jobsTable.$el.append($('<tr><td>' + job.get('program') + '</td></tr>'));
    },
    OnCollapse: function(event) {}
  });

  ForemanListEntry = Backbone.View.extend({
    el: '<li>',
    events: {
      'click a': 'OnForemanClick',
      'contextmenu a': 'OnForemanMenu'
    },
    initialize: function() {
      _.bindAll(this, 'render', 'OnForemanClick', 'OnForemanMenu');
      this.model.bind('change', this.render);
      this.model.bind('remove', (function(_this) {
        return function() {
          _this.$el.remove();
        };
      })(this));
      this.render();
      this.jobsTable = new JobsTableView;
      deploy.jobsTables[this.model.id] = this.jobsTable;
      this.$el.after().append(this.jobsTable.$el);
      return this;
    },
    render: function() {
      this.$el.html(templates.foremen_entry(this.model.toJSON()));
      return this;
    },
    OnForemanClick: function(event) {
      if (this.jobsTable.$el.is(":hidden")) {
        return this.jobsTable.$el.slideDown('fast', (function(_this) {
          return function() {
            return _this.$('span.glyphicon').removeClass('glyphicon-chevron-down').addClass('glyphicon-chevron-up');
          };
        })(this));
      } else {
        return this.jobsTable.$el.slideUp('fast', (function(_this) {
          return function() {
            return _this.$('span.glyphicon').removeClass('glyphicon-chevron-up').addClass('glyphicon-chevron-down');
          };
        })(this));
      }
    },
    OnForemanMenu: function(event) {
      var menu;
      menu = new ContextMenu({
        template: templates.foreman_menu,
        json: this.model.toJSON(),
        x: event.pageX + 1,
        y: event.pageY + 1
      });
      return cancelEvent(event);
    }
  });

  JobsTableView = Backbone.View.extend({
    className: 'job_table',
    initialize: function() {
      this.$el.html('<table><tr><th>Job</th><th>Status</th></tr><tr><td>edge</td><td>Good</td></tr></table>');
      return this;
    }
  });

}).call(this);
