

    ForemenListView = Backbone.View.extend
        el: '#foremen_list'

        events:
            'click b' : 'OnCollapse'

        initialize: () ->
            _.bindAll @, 'OnCollapse'

            deploy.foremen.bind 'add', @AddForeman, @
            deploy.foremen.bind 'reset', (foremen) =>
                foremen.each (foreman) =>
                    @AddForeman(foreman)
                    return
                return

            deploy.jobs.bind 'add', @AddJob, @
            deploy.jobs.bind 'reset', (jobs) =>
                jobs.each (job) =>
                    @AddJob(job)
                    return
                return


            return @

        AddForeman: (foreman) ->
            view = new ForemanListEntry
                model: foreman
            @$el.append(view.$el)
            return

        AddJob: (job) ->
            jobsTable = deploy.jobsTables[job.get('foreman')]
            jobsTable.$el.append($('<tr><td>' + job.get('program') + '</td></tr>'))
            return

        OnCollapse: (event) ->
            return


    ForemanListEntry = Backbone.View.extend
        el: '<li>'

        events:
            'click a' : 'OnForemanClick'
            'contextmenu a' : 'OnForemanMenu'

        initialize: () ->
            _.bindAll @, 'render', 'OnForemanClick', 'OnForemanMenu'

            @model.bind 'change', @render
            @model.bind 'remove', () =>
                @$el.remove()
                return

            @render()

            @jobsTable = new JobsTableView
            deploy.jobsTables[@model.id] = @jobsTable
            @$el.after().append(@jobsTable.$el)

            return @

        render: () ->
            @$el.html templates.foremen_entry @model.toJSON()
            return @

        OnForemanClick: (event) ->
            if @jobsTable.$el.is( ":hidden" )
                @jobsTable.$el.slideDown 'fast', () =>
                    @$('span.glyphicon')
                        .removeClass('glyphicon-chevron-down')
                        .addClass('glyphicon-chevron-up')
            else
                @jobsTable.$el.slideUp 'fast', () =>
                    @$('span.glyphicon')
                        .removeClass('glyphicon-chevron-up')
                        .addClass('glyphicon-chevron-down')

        OnForemanMenu: (event) ->
            menu = new ContextMenu
                template: templates.foreman_menu
                json: @model.toJSON()
                x: event.pageX + 1
                y: event.pageY + 1
            cancelEvent(event)


    JobsTableView = Backbone.View.extend
        className: 'job_table'

        initialize: () ->
            @$el.html('<table><tr><th>Job</th><th>Status</th></tr><tr><td>edge</td><td>Good</td></tr></table>')
            return @
