
This extends the Avispa base class which is the SVG canvas that everything is
drawn on.

    GraphView = Avispa.extend

Bind to the different collections we want to render, handle the initial reset
as well as dynamically adding new objects.

        secondstage: () ->
            deploy.foremen.bind 'add', @AddForeman, @
            deploy.foremen.bind 'reset', (foremen) =>
                foremen.each (foreman) =>
                    @AddForeman(foreman)
                    return
                return

            deploy.jobs.bind 'add', @AddJob, @
            deploy.jobs.bind 'reset', (jobs) =>
                jobs.each (job) =>
                    @AddJob(job)
                    return
                return

            return @

Create a ForemanGroup extended from Avispa.Group and add it to the groups
layer of the canvas.

        AddForeman: (foreman) ->
            view = new ForemanGroup
                model:    foreman
                position: deploy.positions.get(foreman.id)
                parent:   null

            @$groups.append(view.$el)

            return

Create a JobNode and set the parent to the respective ForemanGroup so
that its position gets updated as the foreman is dragged.

        AddJob: (job) ->
            foreman = deploy.foremen.get(job.get('foreman'))

            #TODO: The position information should come from the database.
            p = new Position
                x: 30
                y: 50
                radius: 20
                fill: '#fcc'

            view = new JobNode
                model:    job
                position: p
                parent:   foreman.foremanGroup
                label:    job.get('program')

            @$objects.append(view.$el)

            return

Every graph object has a function like this to clear out context menus when
the user clicks outside the bounds of the menu.

        OnMouseDown: (event) ->
            $('.contextMenu').hide()
            Avispa.prototype.OnMouseDown.call(@, event)

To bring up the normal context menu hold down the shift key.

        OnContextMenu: (event) ->
            return if event.shiftKey

            console.debug('TODO: display context menu')
            return cancelEvent(event)

The ForemanGroup is a container to logically group all the jobs that should be
processed on that machine.

    ForemanGroup = Avispa.Group.extend

        init: () ->
            @model.foremanGroup = @

            @$label = $SVG('text')
                .attr('dx', '0.5em')
                .attr('dy', '1.5em')
                .text(@model.get('id'))
                .appendTo(@$el)

            return @

        render: () ->
            @$rect
                .attr('x', @position.get('x'))
                .attr('y', @position.get('y'))
            @$label
                .attr('x', @position.get('x'))
                .attr('y', @position.get('y'))
            return @

        Drag: (event) ->
            Avispa.Group.prototype.Drag.call(@, event)

            msg =
                action: 'UpdatePosition'
                data: @position.toJSON()
            deploy.ws.send(JSON.stringify(msg))

            return false

        OnMouseDown: (event) ->
            $('.contextMenu').hide()
            Avispa.Group.prototype.OnMouseDown.call(@, event)

Push to the database the position that we stop dragging at.

        OnMouseUp: (event) ->
            @position.save()
            return

        OnContextMenu: (event) ->
            return if event.shiftKey

            cancelEvent(event)

            menu = new ContextMenu
                template: templates.foreman_menu
                json: @model.toJSON()
                x: event.pageX + 1
                y: event.pageY + 1
            return false

The job node represents a process that should be supervised on the foreman's
machine.

    JobNode = Avispa.Node.extend

        Drag: (event) ->
            Avispa.Node.prototype.Drag.call(@, event)
            #msg =
            #    action: 'UpdateJobPosition'
            #    data: @position.toJSON()
            #deploy.ws.send(JSON.stringify(msg))
            return false

        OnMouseDown: (event) ->
            $('.contextMenu').hide()
            Avispa.Node.prototype.OnMouseDown.call(@, event)


