#!/usr/bin/env python

import sys
import os
import zipfile

from distutils.core import setup

try:
    import pip
except ImportError:
    sys.stderr.write('Missing pip module!\n')
    sys.exit(-1)

def add_data_files(*include_dirs):
    data_files = []
    for include_dir in include_dirs:
        for (root,directories,filenames) in os.walk(include_dir):
            include_files = []
            for filename in filenames:
                include_files.append(os.path.join(root,filename))
            if include_files:
                data_files.append((root, include_files))
    return data_files

data_files = add_data_files('etc', 'share', 'var')

zf = zipfile.ZipFile(os.path.join('deploytk', 'skel.zip'), 'w')
for base,directories,filenames in os.walk('skel'):
    for filename in filenames:
        path = os.path.join(base, filename)
        zf.write(path, path[5:])
zf.close()

setup(
    name = 'deploytk',
    version = '0.1.6',
    author = 'Matthew Oertle',
    author_email = 'moertle@gmail.com',
    url = 'https://github.com/moertle/deploy.tk',
    license = 'BSD',
    description = 'A framework for distributed job management',
    long_description = open('README.rst').read(),
    packages = [
        'deploytk',
        'deploytk.handlers',
        ],
    package_data = {
        'deploytk': ['skel.zip']
        },
    scripts = [
        'bin/deploytk-foreman',
        'bin/deploytk-manager'
        ],
    data_files = data_files,
    install_requires = [
        'pyaas >= 0.2.5',
        'pyzmq >= 14.0.1',
        ],
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: BSD License",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 2.6",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.2",
        "Programming Language :: Python :: 3.3",
        "Programming Language :: Python :: 3.4",
        ],
    zip_safe = False
)
