// Generated by CoffeeScript 1.7.1
(function() {
  var ContextMenu, DeployForeman, DialogBox, Foreman, Foremen, Job, Jobs, Link, Links, Manager, Managers, Position, Positions, deployForeman, dialog, templates;

  dialog = {
    resizable: false,
    width: 0,
    minWidth: 200,
    minHeight: 0,
    modal: false
  };

  templates = {};

  $(document).ready(function() {
    $('script[type="text/html-template"]').each(function() {
      templates[this.id] = _.template(this.text);
    });
    $(document).on('dragover', function(event) {
      if (event.preventDefault) {
        event.preventDefault();
      }
      return false;
    });
    $(document).on('drop', function(event) {
      if (event.preventDefault) {
        event.preventDefault();
      }
    });
    $(document).on('keyup', function(event) {
      if (event.keyCode === 27) {
        return $('.contextMenu').remove();
      }
    });
  });

  Job = Backbone.Model.extend({
    url: '/jobs/'
  });

  Jobs = Backbone.Collection.extend({
    model: Job
  });

  Foreman = Backbone.Model.extend({
    url: '/foremen/'
  });

  Foremen = Backbone.Collection.extend({
    model: Foreman
  });

  Manager = Backbone.Model.extend({
    url: '/managers/'
  });

  Managers = Backbone.Collection.extend({
    model: Manager
  });

  Link = Backbone.Model.extend({
    urlRoot: '/links/'
  });

  Links = Backbone.Collection.extend({
    model: Link
  });

  Position = Backbone.Model.extend({
    urlRoot: '/positions/'
  });

  Positions = Backbone.Collection.extend({
    model: Position
  });

  ContextMenu = Backbone.View.extend({
    attributes: {
      "class": 'contextMenu dropdown clearfix'
    },
    events: {
      'click a': 'OnClick'
    },
    initialize: function(options) {
      this.$el.html(options.template(options.json));
      this.$el.css({
        left: options.x,
        top: options.y
      }).appendTo($(document.body));
      return this;
    },
    OnClick: function(event) {
      return this.remove();
    }
  });

  DialogBox = Backbone.View.extend({
    attributes: {
      "class": 'dialogBox'
    },
    initialize: function(options) {
      var $body, $titleBar;
      _.bindAll(this, 'close', 'OnMouseDown', 'OnMouseMove', 'OnMouseUp', 'OnKeyUp');
      $titleBar = $('<div class="titlebar">' + options.title + '<span class="glyphicon glyphicon-remove-sign"></span></div>');
      $body = $('<div class="body">Body</div>');
      this.$el.append($titleBar).append($body).appendTo($(document.body));
      this.$('div.body').html(options.template(options.json));
      this.$el.css({
        left: options.x || (window.innerWidth - this.$el.width()) / 2,
        top: options.y || (window.innerHeight - this.$el.height()) / 2
      });
      $titleBar.find('span').on('click', this.close);
      $titleBar.on('mousedown.dialogBox', this.OnMouseDown);
      $(document).on('mousemove.dialogBox', this.OnMouseMove);
      $(document).on('mouseup.dialogBox', this.OnMouseUp);
      return $(document).on('keyup.dialogBox', this.OnKeyUp);
    },
    close: function(event) {
      this.undelegateEvents();
      this.$el.removeData().unbind();
      this.remove();
      Backbone.View.prototype.remove.call(this);
      $(document).off('.dialogBox');
    },
    OnMouseDown: function(event) {
      if (event.shiftKey) {
        return;
      }
      this.drag = this.$el.offset();
      this.drag.x = event.screenX;
      this.drag.y = event.screenY;
      return cancelEvent(event);
    },
    OnMouseMove: function(event) {
      var x, y;
      if (!this.drag) {
        return;
      }
      x = this.drag.left - this.drag.x + event.screenX;
      y = this.drag.top - this.drag.y + event.screenY;
      this.$el.offset({
        top: y,
        left: x
      });
      return cancelEvent(event);
    },
    OnMouseUp: function(event) {
      this.drag = null;
    },
    OnKeyUp: function(event) {
      if (event.keyCode === 27) {
        return this.close();
      }
    }
  });

  deployForeman = null;

  $(document).ready(function() {
    if (deployForeman == null) {
      deployForeman = new DeployForeman;
    }
  });

  DeployForeman = (function() {
    function DeployForeman() {
      this.dispatch = _.clone(Backbone.Events);
    }

    return DeployForeman;

  })();

}).call(this);
