
import json
import logging

import deploytk
import pyaas

import tornado.web

class Data(pyaas.handlers.Base):
    @tornado.web.authenticated
    def get(self):
        self.set_header('Content-Type', 'text/javascript')

        self.write('var _data={\n' +
            'foremen:'   + deploytk.records.Foremen.Read().json   + ',\n' +
            'managers:'  + deploytk.records.Managers.Read().json  + ',\n' +
            'jobs:'      + deploytk.records.Jobs.Read().json      + ',\n' +
            'positions:' + deploytk.records.Positions.Read().json +  '\n' +
            '};')

class Jobs(pyaas.handlers.Base):
    @tornado.web.authenticated
    def post(self, _id):
        self.set_header('Content-Type', 'application/json')

        values = json.loads(self.request.body)

        try:
            job = deploytk.records.Job.Create(values)
        except pyaas.error as e:
            raise tornado.web.HTTPError(500, e)

        logging.debug('Created job: %s', job.json)

        self.write(job.record)

        self.application.router.Send(str(job.foreman), 'AddJob', job.json)

        #position = dict(
        #    id = identity['id'],
        #    x  = 0,
        #    y  = 0,
        #    w  = 100,
        #    h  = 100,
        #    )
        #deploytk.records.Position.Create(position)
        #self.application.Broadcast(
        #    action = 'CreatePosition',
        #    data   = position
        #    )

        self.application.Broadcast(
            action = 'CreateJob',
            data   = job.record
            )


class Positions(pyaas.handlers.Base):
    @tornado.web.authenticated
    def put(self, _id):
        values = json.loads(self.request.body)

        if _id != values['id']:
            raise tornado.web.HTTPError(500)

        position = deploytk.records.Position.Read(_id)
        if position is None:
            raise tornado.web.HTTPError(404)

        position.Update(values)

