
import socket
import logging

import deploytk

import zmq
import zmq.eventloop
import zmq.eventloop.zmqstream

zmq.eventloop.ioloop.install()

import tornado.ioloop

deploytk.ioloop = tornado.ioloop.IOLoop.instance()

import pyaas

zmqctx = zmq.Context()

__all__ = ['Request', 'Reply', 'Pub', 'Sub', 'Push', 'Pull', 'Dealer', 'Router']

class Base:
    def __init__(self, _type, identity=None, recv=None, send=None):
        self.socket = zmqctx.socket(_type)

        if identity is not None:
            self.socket.identity = identity or socket.getfqdn()
            logging.debug('Setting identity to %s', self.socket.identity)

        self.stream = zmq.eventloop.zmqstream.ZMQStream(self.socket)

        if recv:
            self.stream.on_recv(recv)
        if send:
            self.stream.on_send(send)

    def Bind(self, proto='tcp', host='*', port=0):
        if not port:
            raise ValueError('No port specified')

        uri = '{0}://{1}:{2}'.format(proto, host, port)

        try:
            self.socket.bind(uri)
        except zmq.error.ZMQError as e:
            raise pyaas.error('%s', e)
        return self

    def Connect(self, proto='tcp', host=None, port=0):
        if not host:
            raise ValueError('No host specified')

        if not port:
            raise ValueError('No port specified')

        uri = '{0}://{1}:{2}'.format(proto, host, port)

        try:
            self.socket.connect(uri)
        except zmq.error.ZMQError as e:
            #raise deploy.error('%s', e)
            raise

        return self

    def Send(self, *args):
        self.stream.send_multipart(args)

    def Close(self):
        self.stream.close()
        self.socket.close()

class Request(Base):
    def __init__(self, **kwds):
        Base.__init__(self, zmq.REQ, **kwds)

class Reply(Base):
    def __init__(self, **kwds):
        Base.__init__(self, zmq.REP, **kwds)

class Dealer(Base):
    def __init__(self, **kwds):
        Base.__init__(self, zmq.DEALER, **kwds)

class Router(Base):
    def __init__(self, **kwds):
        Base.__init__(self, zmq.ROUTER, **kwds)

class Pub(Base):
    def __init__(self, **kwds):
        Base.__init__(self, zmq.PUB, **kwds)

class Sub(Base):
    def __init__(self, **kwds):
        Base.__init__(self, zmq.SUB, **kwds)

    def Subscribe(self, filter=''):
        self.socket.setsockopt(zmq.SUBSCRIBE, filter)
        return self

class Push(Base):
    def __init__(self, **kwds):
        Base.__init__(self, zmq.PUSH, **kwds)

class Pull(Base):
    def __init__(self, **kwds):
        Base.__init__(self, zmq.PULL, **kwds)

class Dealer(Base):
    def __init__(self, **kwds):
        Base.__init__(self, zmq.DEALER, **kwds)

class Router(Base):
    def __init__(self, **kwds):
        Base.__init__(self, zmq.ROUTER, **kwds)
