
Define "global" variables

    deploy = null

This is the entry point once the page has been loaded.

    $(document).ready () ->
        new Deploy()

        new Router()
        Backbone.history.start()

        return

The central container that holds most of the objects used by the interface, for
debugging purposes the instance is available in the console as _deploy

    class Deploy
        constructor: () ->
            deploy ?= @
            window._deploy = deploy # for debugging purposes

            nv = new Navbar

            # Track which foreman a job is associated with
            @jobsTables = {}

Setup the models

            # instantiate the models
            @foremen   = new Foremen
            @jobs      = new Jobs
            @positions = new Positions
            #@links     = new Links
            #@arcs      = new Arcs

All the dispatch functions are inlined, not sure if this increases or decreases
readability, but otherwise there were be a disjoint block of functions below

            # setup the dispatcher for websocket messages
            @dispatch = _.clone(Backbone.Events)

            @dispatch.on 'CreateForeman', (msg) ->
                deploy.foremen.add msg
                return
            @dispatch.on 'UpdateForeman', (msg) ->
                deploy.foremen.add msg, merge: true
                return
            @dispatch.on 'DeleteForeman', (msg) ->
                deploy.foremen.remove msg.id
                return

            @dispatch.on 'UpdateForemanText', (msg) ->
                model = @foremen.get(msg.id)
                console.log('>>>', model, msg.text)
                model.foreman.dom.status.text(msg.text)
                return

            @dispatch.on 'CreateManager', (msg) ->
                deploy.managers.add msg
                return
            @dispatch.on 'UpdateManager', (msg) ->
                deploy.managers.add msg, merge: true
                return
            @dispatch.on 'DeleteManager', (msg) ->
                deploy.managers.remove msg.id
                return

            @dispatch.on 'CreateJob', (msg) ->
                console.log('CreateJob', msg)
                deploy.jobs.add msg
                return
            @dispatch.on 'UpdateJob', (msg) ->
                deploy.jobs.add msg, merge: true
                return
            @dispatch.on 'DeleteJob', (msg) ->
                deploy.jobs.remove msg.id
                return

            @dispatch.on 'CreatePosition', (msg) ->
                deploy.positions.add msg
                return
            @dispatch.on 'UpdatePosition', (msg) ->
                position = deploy.positions.get(msg.id)
                if position
                then position.set 'x': msg.x, 'y': msg.y
                else console.warn('Position not available')
                return
            @dispatch.on 'UpdateArc', (msg) ->
                arc = deploy.arcs.get(msg._id)
                if arc
                then arc.set 'arc', msg.arc
                else console.warn('Arc not available')
                return

Attach to the SVG element

            @graph = new GraphView
                el: $('#surface svg')

Setup the views

            @foremenListView = new ForemenListView

            # instantiate views and associate models
            #views.foremen = new Views.Foreman
            #    collection: @foremen

Load the boot-strapped model data

            @positions.reset _data.positions
            #@arcs.reset      _data.arcs
            @foremen.reset   _data.foremen
            @jobs.reset      _data.jobs
            #@links.reset     _data.links

            #$('#manager').html _.template($('#template_main').text(), models)

Connect the websocket for a real-time shared view of the state of the system

            @WebsocketConnect()

            return

So the server has a ping -> pong, but it seemed easier for the clients to send
a ping instead of the server iterating over all the clients. The purpose is to
keep the connection alive in case some router timeouts the connection.

        WebsocketConnect: () ->
            @timeout = 0.9375 if not @timeout?

            protocol = location.protocol.replace('http','ws')
            @ws = new WebSocket("#{protocol}://#{location.host}/ws")

            @ws.onopen = (event) =>
                @timeout = 0.9375
                @interval = setInterval () =>
                    @ws.send('ping')
                    return
                  ,
                    1000 * 60
                return

On message from the server, dispatch it the event handler in Deploy. The
protocol is simply a JSON object of {action:'event', data:<arbirtary data>}.

            @ws.onmessage = (event) =>
                msg = JSON.parse(event.data)
                #console.debug(msg.action, msg.data)
                @dispatch.trigger(msg.action, msg.data)
                return

            @ws.onerror = (event) =>
                clearInterval(@interval)
                @timeout = @timeout * 2
                return

            @ws.onclose = (event) =>
                clearInterval(@interval)

                if @timeout > 60
                    console.warn('Unable to reconnect to server, giving up.')
                    alert('Lost connection to the server')
                    return

                console.info('Connection closed, reconnecting in', Math.round(@timeout))
                setTimeout () =>
                    @WebsocketConnect()
                    return
                  ,
                    1000 * @timeout
                return

            return
