
Generic view for creating context menus. Options should include the x and y,
the template to use, and an optional json object if the template has any
parameters.

    ContextMenu = Backbone.View.extend
        attributes:
            class: 'contextMenu dropdown clearfix'

        events:
            'click a' : 'OnClick'

        initialize: (options) ->
            @$el.html options.template options.json

            @$el.css
                left: options.x
                top:  options.y
            .appendTo($(document.body))

            return @

        OnClick: (event) ->
            @remove()

Pretty dialog box that looks a lot like Bootstrap and not like jQuery UI.
Could be cleaner, but works for now.

    DialogBox = Backbone.View.extend
        attributes:
            class: 'dialogBox'

        initialize: (options) ->
            _.bindAll @, 'close', 'OnMouseDown', 'OnMouseMove', 'OnMouseUp', 'OnKeyUp'

            $titleBar = $('<div class="titlebar">'+options.title+'<span class="glyphicon glyphicon-remove-sign"></span></div>')
            $body = $('<div class="body">Body</div>')

            @$el.append($titleBar).append($body).appendTo($(document.body))

            @$('div.body').html options.template options.json

            @$el.css
                left: options.x or (window.innerWidth  - @$el.width())  / 2
                top:  options.y or (window.innerHeight - @$el.height()) / 2

            $titleBar.find('span').on 'click', @close

            $titleBar.on   'mousedown.dialogBox', @OnMouseDown
            $(document).on 'mousemove.dialogBox', @OnMouseMove
            $(document).on 'mouseup.dialogBox',   @OnMouseUp
            $(document).on 'keyup.dialogBox',     @OnKeyUp

        close: (event) ->
            @undelegateEvents()
            @$el.removeData().unbind()
            @remove()
            Backbone.View.prototype.remove.call(@)

            $(document).off '.dialogBox'
            return

        # support dragging the window around
        OnMouseDown: (event) ->
            return if event.shiftKey

            @drag   = @$el.offset()
            @drag.x = event.screenX
            @drag.y = event.screenY

            cancelEvent(event)

        OnMouseMove: (event) ->
            return if not @drag

            x = @drag.left - @drag.x + event.screenX
            y = @drag.top  - @drag.y + event.screenY
            @$el.offset(top: y, left: x)

            cancelEvent(event)

        OnMouseUp: (event) ->
            @drag = null
            return

        OnKeyUp: (event) ->
            @close() if event.keyCode is 27
