import os

import digue.lilypond_snippets as ls

def __manage_overlaps(ins_list):
	i = 0
	while i < len(ins_list):
		sim = [i]
		j = i+1
		while j < len(ins_list):
			if ins_list[i].variable == ins_list[j].variable:
				sim.append(j)
			j = j+1
		if len(sim) > 1:
			for k in range(0, len(sim)):
				ins_list[sim[k]].number = k+1
		i = i+1
	return ins_list

def __create_file(outfile, s):
	file_open = open(outfile, 'a')
	file_open.write(s)
	file_open.close()

def create_project(instruments_list, config):
	instruments_list = __manage_overlaps(instruments_list)

	os.mkdir('PDF')
	os.mkdir('MIDI')
	os.mkdir('Notes')
	os.mkdir('Parts')

	__create_file("Makefile", ls.makefile())
	__create_file("Infos.ly", ls.infos(config))
	__create_file("Score.ly", ls.score(instruments_list, config))

	for instrument in instruments_list:
		__create_file(
				"Parts/{0}.ly".format(instrument.variable),
				instrument.part(config))
		__create_file(
				"Notes/{0}.ily".format(instrument.variable),
				instrument.notes(config))

