from digue.instruments_classes import *

import collections

# Types

staff_instrument = {
		"type": "StaffInstrument",
		"instrument_name": "Staff instrument",
		"category": "Types"
}

transposing_instrument = {
		"type": "TransposingInstrument",
		"instrument_name": "Transposing instrument",
		"category": "Types"
}

pianostaff_instrument = {
		"type": "PianoStaffInstrument" ,
		"instrument_name": "Instrument",
		"category": "Types"
}

drumstaff_instrument = {
		"type": "DrumStaffInstrument",
		"instrument_name": "Drumstaff Instrument",
		"category": "Types"
}

tabstaff_instrument = {
		"type": "TabStaffInstrument",
		"instrument_name": "Plucked strings instrument",
		"category": "Types"
}

lyricsstaff_instrument = {
		"type": "LyricsStaffInstrument",
		"instrument_name": "Lyrics instrument",
		"category": "Types"
}


# Vocals

soprano = {
		"type": "LyricsStaffInstrument",
		"variable": "Soprano",
		"instrument_name": "Soprano",
		"short_instrument_name": "S.",
		"midi_instrument": 'choir aahs',
		"clef": "treble",
		"category": "Vocals"
}

alto = {
		"type": "LyricsStaffInstrument",
		"variable": "Alto",
		"instrument_name": "Alto",
		"short_instrument_name": "A.",
		"midi_instrument": 'choir aahs',
		"clef": "alto",
		"category": "Vocals"
}

tenor = {
		"type": "LyricsStaffInstrument",
		"variable": "Tenor",
		"instrument_name": "Tenor",
		"short_instrument_name": "T.",
		"midi_instrument": 'choir aahs',
		"clef": "bass",
		"category": "Vocals"
}

bass = {
		"type": "LyricsStaffInstrument",
		"variable": "Bass",
		"instrument_name": "Bass",
		"short_instrument_name": "B.",
		"midi_instrument": 'choir aahs',
		"clef": "bass",
		"category": "Vocals"
}


# Woodwinds

flute = {
		"type": "StaffInstrument",
		"variable": "Flute",
		"instrument_name": "Flute",
		"short_instrument_name": "Fl.",
		"midi_instrument": 'flute',
		"clef": "treble",
		"category": "Woodwinds"
}

clarinet = {
		"type": "TransposingInstrument",
		"variable": "Clarinet",
		"instrument_name": "Clarinet",
		"short_instrument_name": "Cl.",
		"midi_instrument": 'clarinet',
		"clef": "treble",
		"transposition": "bes",
		"clef_concert_pitch": "treble",
		"category": "Woodwinds"
}

bass_clarinet = {
		"type": "TransposingInstrument",
		"variable": "BassClarinet",
		"instrument_name": "Bass Clarinet",
		"short_instrument_name": "B. Cl.",
		"midi_instrument": 'clarinet',
		"clef": "treble",
		"transposition": "bes,",
		"clef_concert_pitch": "bass",
		"category": "Woodwinds"
}


# Strings

violin = {
		"type": "StaffInstrument",
		"variable": "Violin",
		"instrument_name": "Violin",
		"short_instrument_name": "Vln.",
		"midi_instrument": 'violin',
		"clef": "treble",
		"category": "Strings"
}

viola = {
		"type": "StaffInstrument",
		"variable": "Viola",
		"instrument_name": "Viola",
		"short_instrument_name": "Vla.",
		"midi_instrument": 'viola',
		"clef": "alto",
		"category": "Strings"
}

cello = {
		"type": "StaffInstrument",
		"variable": "Cello",
		"instrument_name": "Cello",
		"short_instrument_name": "C.",
		"midi_instrument": 'cello',
		"clef": "bass",
		"category": "Strings"
}

# Keyboards

piano = {
		"type": "PianoStaffInstrument",
		"variable": "Piano",
		"instrument_name": "Piano",
		"short_instrument_name": "P.",
		"midi_instrument": 'acoustic grand',
		"category": "Keyboards"
}


# Plucked strings

guitar = {
		"type": "TabStaffInstrument",
		"variable": "Guitar",
		"instrument_name": "Guitar",
		"short_instrument_name": "Gtr.",
		"midi_instrument": 'acoustic guitar (nylon)',
		"clef": "treble",
		"transposing": 1,
		"category": "Plucked strings"
}

bass_guitar = {
		"type": "TabStaffInstrument",
		"variable": "BassGuitar",
		"instrument_name": "Bass Guitar",
		"short_instrument_name": "B. Gtr.",
		"midi_instrument": 'electric bass (finger)',
		"clef": "bass",
		"transposing": 1,
		"string_tunings": "bass-tuning",
		"category": "Plucked strings"
}


predefined_instruments = [
		staff_instrument, transposing_instrument, pianostaff_instrument,
		drumstaff_instrument, tabstaff_instrument, lyricsstaff_instrument,
		soprano, alto, tenor, bass,
		flute,
		clarinet, bass_clarinet,
		violin, viola, cello,
		piano,
		guitar, bass_guitar
]

