from setuptools import setup

# Work around mbcs bug in distutils.
# http://bugs.python.org/issue10945
import codecs
try:
    codecs.lookup('mbcs')
except LookupError:
    ascii = codecs.lookup('ascii')
    func = lambda name, enc=ascii: {True: enc}.get(name=='mbcs')
    codecs.register(func)

setup(
    name = "digue",
    packages = ["digue"],
    entry_points = {
        'console_scripts': [
        ],
        'gui_scripts': [
            'digue = digue.gui:main',
        ]
    },
    install_requires = [
        'appdirs'
    ],
    license = "GNU GPL",
    version = "0.0.1",
    description = "Lilypond new score wizard",
    author = "Anton Curl",
    author_email = "curl.anton@gmail.com",
    url = "https://pypi.python.org/pypi/digue/",
    download_url = "https://pypi.python.org/pypi/digue/",
    keywords = ["lilypond"],
    classifiers = [
        "Programming Language :: Python :: 3",
        "Development Status :: 2 - Pre-Alpha",
        "Environment :: Other Environment",
        "Intended Audience :: End Users/Desktop",
        "License :: OSI Approved :: GNU General Public License (GPL)",
        "Natural Language :: English",
        "Operating System :: OS Independent",
    ],
    long_description = """\
Digue
-------------------------------------

This program will help you to create the skeleton of your Lilypond score. It is
mostly oriented for scores with separate parts.

It creates several files:
- Score.ly contains the full score.
- Each file in Parts/ contains the score bloc for one instrument. PDF files
  will be generated in the PDF/ folder and MIDI files in the MIDI/ folder.
- The Notes/ directory contains the files you are going to edit to fill your
  score.

To generate the score, run make.

To generate the parts, run make parts.
"""
)
