import digue.lilypond_language as ll

import configparser
import appdirs
import os

from tkinter import *
from tkinter import ttk

class _RadioButtonSetting:

	def __init__(self, master, setting_name, default_value):
		self.__value = StringVar()
		self.__value.set(default_value)
		ttk.Label(master, text=setting_name).grid(
				column=0, row=0, sticky=W)
		ttk.Radiobutton(master, text='Yes', variable=self.__value, value='1') \
				.grid(column=1, row=0, sticky=E)
		ttk.Radiobutton(master, text='No' , variable=self.__value, value='0') \
				.grid(column=2, row=0, sticky=E)

	def get(self):
		return self.__value.get()

class InstrumentsNames(_RadioButtonSetting):

	id = "display_instruments_names"
	default_value = '1'

	def __init__(self, master):
		super().__init__(
				master, "Display instruments names", self.default_value)

class ShortInstrumentsNames(_RadioButtonSetting):

	id = "display_short_instruments_names"
	default_value = '1'

	def __init__(self, master):
		super().__init__(
				master, "Display short instruments names", self.default_value)

class Language:

	id = "language"
	default_value = "nederlands"

	def __init__(self, master):
		ttk.Label(master, text="Language").grid(row=0, column=0, sticky=W)
		c = self.__combobox = ttk.Combobox(
				master, state="readonly", justify="right")
		c["values"] = list(ll.language.keys())
		c.set(self.default_value)
		c.grid(row=0, column=1, sticky=E)

	def get(self):
		return self.__combobox.get()

class IndentString:

	id = "indent_string"
	default_value = '"  "'

	def __init__(self, master):
		self.__variable = StringVar()
		self.__variable.set(self.default_value)
		ttk.Label(master, text="Indent string") \
				.grid(column=0, row=0, sticky=W)
		ttk.Entry(master, textvariable=self.__variable, justify="right") \
				.grid(column=1, row=0, sticky=E)

	def get(self):
		return self.__variable.get()

settings_list = [
		InstrumentsNames,
		ShortInstrumentsNames,
		Language,
		IndentString
]

settings_dict = {}
for setting in settings_list:
	settings_dict[setting.id] = setting

# Updating default values according to configuration file.
config = configparser.ConfigParser()
appname = "digue"
config_dir = appdirs.user_config_dir(appname)
config_file = os.path.join(config_dir, appname+".conf")
if os.path.isfile(config_file):
	config.read(config_file)
	for k, v in config['DEFAULT'].items():
		settings_dict[k].default_value = v

def save(config):
	config_parser = configparser.ConfigParser()
	config_parser['DEFAULT'] = config
	appname = "digue"
	config_dir = appdirs.user_config_dir(appname)
	if not os.path.isdir(config_dir):
		os.mkdir(config_dir)
	config_file = os.path.join(config_dir, appname+".conf")
	with open(config_file, 'w') as configfile:
		config_parser.write(configfile)

