from tkinter import *
from tkinter import ttk

class InstrumentSettings:

	def __init__(self, master, settings_list):
		self.__settings_list = []
		self.__frame_list = []
		for setting in settings_list:
			self.__frame_list.append(ttk.Frame(master))
			self.__frame_list[-1].columnconfigure(0, weight=1)
			self.__frame_list[-1].rowconfigure(0, weight=1)
			self.__settings_list.append(setting(self.__frame_list[-1]))
		for row in range(0, len(self.__frame_list)):
			self.__frame_list[row].grid(row=row, sticky=(E, W), pady=2)

	def set(self, setting_id, value):
		for setting in self.__settings_list:
			if setting.id == setting_id:
				setting.set(value)

	def get_list(self):
		settings_values_list = []
		for setting in self.__settings_list:
			settings_values_list.append(setting.get())
		return settings_values_list

	def get_dict(self):
		settings_value_dict = {}
		for setting in self.__settings_list:
			settings_value_dict[setting.id] = setting.get()
		return settings_value_dict

	def get(self, setting_id):
		for setting in self.__settings_list:
			if setting.id == setting_id:
				return setting.get()

class _EntrySetting:

	def __init__(self, master, name):
		self.__variable = StringVar()
		ttk.Label(master, text=name) \
				.grid(column=0, row=0, sticky=W)
		ttk.Entry(master, textvariable=self.__variable) \
				.grid(column=0, row=1, sticky=(W, N, S, E))

	def set(self, value):
		self.__variable.set(value)

	def get(self):
		return self.__variable.get()

class Variable(_EntrySetting):

	id = "variable"

	def __init__(self, master):
		super().__init__(master, "Variable")

class InstrumentName(_EntrySetting):

	id = "instrument_name"

	def __init__(self, master):
		super().__init__(master, "Instrument Name")

class ShortInstrumentName(_EntrySetting):

	id = "short_instrument_name"

	def __init__(self, master):
		super().__init__(master, "Short instrument name")

class _ComboboxSetting:

	def __init__(self, master, name, list):
		ttk.Label(master, text=name) \
				.grid(row=0, column=0, sticky=(W, E))
		self.__combobox = ttk.Combobox(master)
		self.__combobox["values"] = list
		self.__combobox.set(list[0])
		self.__combobox.grid(row=1, column=0, sticky=(W, E))

	def set(self, value):
		self.__combobox.set(value)

	def get(self):
		return self.__combobox.get()

class _CheckButtonSetting:

	def __init__(self, master, name):
		self.__var = IntVar()
		ttk.Label(master, text=name).grid(column=0, row=0, sticky=W)
		self.__checkbutton = Checkbutton(master, variable=self.__var) \
				.grid(column=1, row=0, sticky=E)

	def get(self):
		return self.__var.get()

	def set(self, n):
		self.__var.set(n)

class ConcertPitch(_CheckButtonSetting):

	id = "concert_pitch"

	def __init__(self, master):
		super().__init__(master, "Concert pitch in score")

class IsTransposing(_CheckButtonSetting):

	id = "transposing"

	def __init__(self, master):
		super().__init__(master, "Transposing")

class _ReadonlyComboboxSetting:

	def __init__(self, master, name, list):
		self.__list = list
		ttk.Label(master, text=name) \
				.grid(row=0, column=0, sticky=W)
		self.__combobox = ttk.Combobox(master, state="readonly")
		self.__combobox["values"] = self.__list
		self.__combobox.current(0)
		self.__combobox.grid(row=1, column=0, sticky=(W, E))

	def set(self, midi_instrument):
		if midi_instrument not in self.__list:
			NameError("Invalid MIDI instrument.")
		self.__combobox.set(midi_instrument)

	def get(self):
		return self.__combobox.get()

class MIDIInstrument(_ReadonlyComboboxSetting):

	midi_instrument_list = [
			"acoustic grand",
			"bright acoustic",
			"electric grand",
			"honky-tonk",
			"electric piano 1",
			"electric piano 2",
			"harpsichord",
			"clav",
			"celesta",
			"glockenspiel",
			"music box",
			"vibraphone",
			"marimba",
			"xylophone",
			"tubular bells",
			"dulcimer",
			"drawbar organ",
			"percussive organ",
			"rock organ",
			"church organ",
			"reed organ",
			"accordion",
			"harmonica",
			"concertina",
			"acoustic guitar (nylon)",
			"acoustic guitar (steel)",
			"electric guitar (jazz)",
			"electric guitar (clean)",
			"electric guitar (muted)",
			"overdriven guitar",
			"distorted guitar",
			"guitar harmonics",
			"acoustic bass",
			"electric bass (finger)",
			"electric bass (pick)",
			"fretless bass",
			"slap bass 1",
			"slap bass 2",
			"synth bass 1",
			"synth bass 2",
			"violin",
			"viola",
			"cello",
			"contrabass",
			"tremolo strings",
			"pizzicato strings",
			"orchestral harp",
			"timpani",
			"string ensemble 1",
			"string ensemble 2",
			"synthstrings 1",
			"synthstrings 2",
			"choir aahs",
			"voice oohs",
			"synth voice",
			"orchestra hit",
			"trumpet",
			"trombone",
			"tuba",
			"muted trumpet",
			"french horn",
			"brass section",
			"synthbrass 1",
			"synthbrass 2",
			"soprano sax",
			"alto sax",
			"tenor sax",
			"baritone sax",
			"oboe",
			"english horn",
			"bassoon",
			"clarinet",
			"piccolo",
			"flute",
			"recorder",
			"pan flute",
			"blown bottle",
			"shakuhachi",
			"whistle",
			"ocarina",
			"lead 1 (square)",
			"lead 2 (sawtooth)",
			"lead 3 (calliope)",
			"lead 4 (chiff)",
			"lead 5 (charang)",
			"lead 6 (voice)",
			"lead 7 (fifths)",
			"lead 8 (bass+lead)",
			"pad 1 (new age)",
			"pad 2 (warm)",
			"pad 3 (polysynth)",
			"pad 4 (choir)",
			"pad 5 (bowed)",
			"pad 6 (metallic)",
			"pad 7 (halo)",
			"pad 8 (sweep)",
			"fx 1 (rain)",
			"fx 2 (soundtrack)",
			"fx 3 (crystal)",
			"fx 4 (atmosphere)",
			"fx 5 (brightness)",
			"fx 6 (goblins)",
			"fx 7 (echoes)",
			"fx 8 (sci-fi)",
			"sitar",
			"banjo",
			"shamisen",
			"koto",
			"kalimba",
			"bagpipe",
			"fiddle",
			"shanai",
			"tinkle bell",
			"agogo",
			"steel drums",
			"woodblock",
			"taiko drum",
			"melodic tom",
			"synth drum",
			"reverse cymbal",
			"guitar fret noise",
			"breath noise",
			"seashore",
			"bird tweet",
			"telephone ring",
			"helicopter",
			"applause",
			"gunshot",
	]

	id = "midi_instrument"

	def __init__(self, master):
		super().__init__(master,
		               "MIDI instrument",
		               self.midi_instrument_list)

class Clef(_ComboboxSetting):

	clef_list = ["treble", "alto", "bass"]

	id = "clef"

	def __init__(self, master):
		super().__init__(master, "Clef", self.clef_list)

class ClefConcertPitch(_ComboboxSetting):

	id = "clef_concert_pitch"

	def __init__(self, master):
		super().__init__(master, "Clef concert pitch", Clef.clef_list)

class Transposition(_ComboboxSetting):

	id = "transposition"

	transposition_list = [
			"c''",  # Piccolo
			"ees'",
			"d'",
			"bes",  # Clarinet
			"a",
			"g",
			"f",
			"ees",
			"c",    # Guitar, Bass Guitar…
			"bes,"  # Bass clarinet
	]

	def __init__(self, master):
		super().__init__(master, "Transposition", self.transposition_list)

class _Number(_ReadonlyComboboxSetting):

	list = ["1", "2", "3", "4"]

	def __init__(self, master, name):
		super().__init__(master, name, self.list)

class NumberOfVoices(_Number):

	id = "number_of_voices"

	def __init__(self, master):
		super().__init__(master, "Number of voices")

class NumberOfVoicesRight(_Number):

	id = "number_of_voices_right"

	def __init__(self, master):
		super().__init__(master, "Number of voices for right hand")

class NumberOfVoicesLeft(_Number):

	id = "number_of_voices_left"

	def __init__(self, master):
		super().__init__(master, "Number of voices for left hand")

class NumberOfVerses(_ReadonlyComboboxSetting):

	id = "number_of_verses"
	list = ["0", "1", "2", "3", "4"]

	def __init__(self, master):
		super().__init__(master, "Number of verses", self.list)

class ScoreTabDisplay(_ReadonlyComboboxSetting):

	id = "score_tab_display"

	list = ["Score", "Tab", "Both"]

	def __init__(self, master):
		super().__init__(master, "Display", self.list)

class StringTunings(_ComboboxSetting):

	id = "string_tunings"

	string_tunings_list = [
			"guitar-tuning",
			"guitar-seven-string-tuning",
			"guitar-drop-d-tuning",
			"guitar-drop-c-tuning",
			"guitar-open-g-tuning",
			"guitar-open-d-tuning",
			"guitar-dadgad-tuning",
			"guitar-lute-tuning",
			"guitar-asus4-tuning",
			"bass-tuning",
			"bass-four-string-tuning",
			"bass-drop-d-tuning",
			"bass-five-string-tuning",
			"bass-six-string-tuning",
			"mandolin-tuning",
			"banjo-open-g-tuning",
			"banjo-c-tuning",
			"banjo-modal-tuning",
			"banjo-open-d-tuning",
			"banjo-open-dm-tuning",
			"ukulele-tuning",
			"ukulele-d-tuning",
			"tenor-ukulele-tuning",
			"baritone-ukulele-tuning",
			"violin-tuning",
			"viola-tuning",
			"cello-tuning",
			"double-bass-tuning",
			"\stringTuning <e, a, d g b e'>"
	]

	def __init__(self, master):
		super().__init__(master, "String Tunings", self.string_tunings_list)

