def indent(s, config):
	st = s
	indent_level = 0
	indent_char = config["indent_string"][1:-1]
	i = 0
	while i < len(st)-3:
		if st[i] == '{' or st[i:i+2] == '<<':
			indent_level += 1
		if st[i+1] == '}' or st[i+1:i+3] == '>>':
			indent_level -= 1
		if st[i] == '\n':
			st = st[0:i+1] + indent_char*indent_level + st[i+1:len(st)]
			while st[i].isspace():
				i += 1
			if st[i] == '{' or st[i:i+2] == '<<':
				i -= 1
		i += 1
	return st

# http://lilypond.org/doc/v2.18/Documentation/notation/writing-pitches.html#note-names-in-other-languages
language = {
		'nederlands': {
			'c': 'c',
			'd': 'd',
			'e': 'e',
			'f': 'f',
			'g': 'g',
			'a': 'a',
			'bes': 'bes',
			'b': 'b',
			'es': 'es',
			'is': 'is',
			'eses': 'eses',
			'isis': 'isis'
		},
		'italiano': {
			'c': 'do',
			'd': 're',
			'e': 'mi',
			'f': 'fa',
			'g': 'sol',
			'a': 'la',
			'bes': 'sib',
			'b': 'si',
			'es': 'b',
			'is': 'd',
			'eses': 'bb',
			'isis': 'dd'
		},
}

