from digue.lilypond_language import *

def makefile():
	return """\
LILYCMD=$(shell which lilypond)
PARTS=$(shell echo Parts/*.ly)
NOTES=$(shell echo Notes/*.ily)
PDF=$(PARTS:Parts/%.ly=PDF/%.pdf)
MIDI=$(PARTS:Parts/%.ly=MIDI/%.midi)

.PHONY: all full parts

all: Score.pdf Score.midi

full: all parts

parts: $(PDF) ${MIDI}

Score.pdf Score.midi: Score.ly
	$(LILYCMD) $<

PDF/%.pdf MIDI/%.midi: Parts/%.ly
	$(LILYCMD) -o "$*" "$<"
	if test -f "$*.pdf";  then mv "$*.pdf"  PDF/;  fi
	if test -f "$*.midi"; then mv "$*.midi" MIDI/; fi

Score.ly: Infos.ly $(NOTES)
	touch $@

Parts/%.ly: Infos.ly Notes/%.ily
	touch $@
"""

def score(instruments_list, config):
	s = '\\include "Infos.ly"\n'
	for instrument in instruments_list:
		s += '\\include "Notes/{0}.ily"\n'.format(instrument.variable)
	s += "\nmusic = \keepWithTag #'score <<\n"
	for instrument in instruments_list:
		s += '\\{0}\n'.format(instrument.variable)
	s += ">>\n\n" \
	     "\score {\n\music\n\layout { }\n}\n\n" \
	     "\score {\n\\unfoldRepeats \\articulate << \music >>\n" \
	     "\midi { \midiTempo }\n}\n\n"
	return indent(s, config)

def infos(config):
	lang = config["language"]
	do = language[lang]["c"]
	import subprocess
	version = subprocess.check_output(
			["lilypond", "--version"], universal_newlines=True)
	version = version.split('\n', 1)[0]
	version = version.split(' ', 2)[2]
	s = '\\version "{0}"\n' \
	    '\include "articulate.ly"\n' \
	    '\language "{1}"\n\n' \
	    '\header {{\n' \
	    'dedication  = ##f\n' \
	    'title       = ##f\n' \
	    'subtitle    = ##f\n' \
	    'subsubtitle = ##f\n' \
	    'instrument  = ##f\n' \
	    'composer    = ##f\n' \
	    'arranger    = ##f\n' \
	    'poet        = ##f\n' \
	    'meter       = ##f\n' \
	    'piece       = ##f\n' \
	    'opus        = ##f\n' \
	    'copyright   = ##f\n' \
	    'tagline     = ##f\n' \
	    '}}\n\n' \
	    'global = {{\n' \
	    '\set Score.skipBars = ##t\n' \
	    '\key {2} \major\n' \
	    '\\time 4/4\n' \
	    '\\tempo 4=120\n' \
	    '\\repeat unfold 4 {{ s1 }}\n' \
	    '\\bar "|."\n' \
	    '}}\n\n' \
	    'midiTempo = {{ \\tempo 4=120 }}\n\n'.format(version, lang, do)
	return indent(s, config)

