from django import forms
from django.conf import settings
import pytz
from dimagi.utils.timezones import zones
from dimagi.utils.timezones.utils import adjust_datetime_to_timezone, coerce_timezone_value

class TimeZoneChoiceField(forms.TypedChoiceField):
    def __init__(self, *args, **kwargs):
        if not "choices" in kwargs:
            kwargs["choices"] = zones.PRETTY_TIMEZONE_CHOICES
        kwargs["coerce"] = coerce_timezone_value
        super(TimeZoneChoiceField, self).__init__(*args, **kwargs)

#class LocalizedDateTimeField(forms.DateTimeField):
#    """
#    Converts the datetime from the user timezone to settings.TIME_ZONE.
#    """
#    def __init__(self, timezone=None, *args, **kwargs):
#        super(LocalizedDateTimeField, self).__init__(*args, **kwargs)
#        self.timezone = timezone or settings.TIME_ZONE
#
#    def clean(self, value):
#        value = super(LocalizedDateTimeField, self).clean(value)
#        if value is None: # field was likely not required
#            return None
#        return adjust_datetime_to_timezone(value, from_tz=self.timezone)