Generates a bootable ISO image from the kernel/ramdisk generated by the
elements ``baremetal`` or ``ramdisk``. It uses isolinux to boot on BIOS
machines and grub to boot on EFI machines.

This element has been tested on the following distro(s):
* ubuntu
* fedora

**NOTE**: For other distros, please make sure the ``isolinux.bin`` file
exists at ``/usr/lib/syslinux/isolinux.bin``.

baremetal element
-----------------
When used with ``baremetal`` element, this generates a bootable ISO image
named ``<image-name>-boot.iso`` booting the generated kernel and ramdisk.
It also automatically appends kernel command-line argument
'root=UUID=<uuid-of-the-root-partition>'.  Any more kernel command-line
arguments required may be provided by specifying them in
``DIB_BOOT_ISO_KERNEL_CMDLINE_ARGS``.

**NOTE**: It uses pre-built efiboot.img by default to work for UEFI machines.
This is because of a bug in latest version of grub[1].  The user may choose
to avoid using pre-built binary and build efiboot.img on their own machine
by setting the environment variable DIB\_UEFI\_ISO\_BUILD\_EFIBOOT to 1 (this
might work only on certain versions of grub). The current efiboot.img was
generated by the method build\_efiboot\_img() in 100-build-iso on
Ubuntu 13.10 with grub 2.00-19ubuntu2.1.

ramdisk element
---------------
When used with ``ramdisk`` element, this generates a bootable ISO image
named ``<image-name>.iso`` booting the generated kernel and ramdisk. It also
automatically appends kernel command-line argument 'boot\_method=vmedia'
which is required for Ironic drivers ``iscsi_ilo``.

**REFERENCES**

[1] https://bugs.launchpad.net/ubuntu/+source/grub2/+bug/1378658
