# This module allows matches a message based on a regex 
# Ivan Willig, Modi Labs, Thu Dec  9 08:19:54 2010
#
import re 
from importlib import import_module 
from collections import namedtuple
from types import FunctionType

class Message(object):
    langauge = None
    reqex = None

    def __init__(self, text, number):
        self.text = text
        self.number = number

    def __unicode__(self):
        return "Message %s" % self.text
        
class Dispatcher(object):
    """
    Machtes reqex to functions. 
    """
    match = namedtuple('Match','matcher location langauge')
    finalMatcher = None
    matchers = []
    results = None
    
    def __init__(self):
        """
        """

        
    def addMatcher(self,matcher,function,langauge="en"):
        """ Addes a matcher to a private list of possible matchers"""
        self.matchers.append(
            self.match(matcher,function,langauge))            
    
    def catchAll(self,matcher):
        self.finalMatcher = matcher 

    def findModule(self,location):
        """From a given path returns a python function """
        pathParts = re.split("\W+",location)
        module= import_module(".".join(pathParts[:2]))
        return getattr(module,pathParts[2])

    def matchMessage(self,message):
        """Parses message and matches accordingly """
        for match in self.matchers:
            if isinstance(match.matcher,str):
                self.results = re.match(match.matcher,message.text.lower())
                message.reqex = self.results
            elif isinstance(match.matcher,FunctionType):
                self.results = match.matcher(message)
            if self.results:
                # append the message object
                # with new properties
                message.langauge = match.langauge
                if isinstance(match.location, FunctionType):
                    # if they give us a function, call it
                    match.location(message)
                elif isinstance(match.location,str):
                    # inspect the given path
                    function = self.findModule(match.location)
                    function(message)
                else:
                    raise NameError("Unsupported callier for matcher")
        # catch the message with the finalMatcher
        
