# -*- coding: utf-8 -*-
from django.conf import settings
from django.core.exceptions import ImproperlyConfigured


def current_url(request):
    """
    Get the current page's url.

    @return: (dict).
    """
    return {'current_url': request.get_full_path()}


def site_name(request):
    """
    Get the site name.

    @return: (dict).
    """
    return {'site_name': settings.SITE_NAME}


def use_ga(request):
    """
    Get the USE_GA env variable.

    @param request: (HttpRequest).
    @return (dict).
    """
    try:
        return {'use_ga': settings.USE_GA}
    except AttributeError:
        raise ImproperlyConfigured('USE_GA not set.')
