# -*- coding: utf-8 -*-
from django.contrib.auth import login
from django.contrib.auth.models import User
from django.http import HttpResponseRedirect
from django.views.generic.base import TemplateView


class LoginView(TemplateView):
    """
    Login user specified by her PK.
    """
    def get(self, request, *args, **kwargs):
        user = User.objects.get(pk=kwargs['user_pk'])
        user.backend = 'django.contrib.auth.backends.ModelBackend'
        login(request, user)

        return HttpResponseRedirect('/')
