# -*- coding: utf-8 -*-
import logging
import traceback


class RequestDetailsFormatter(logging.Formatter):
    """
    Logging formatter that outputs extra information about the logged in user.
    """
    def format(self, record):
        s = super(RequestDetailsFormatter, self).format(record)

        s2 = ''
        try:
            request = record.request
            s2 += '\tBrowser: %s\n' % \
                  request.META.get('HTTP_USER_AGENT', 'NO DATA')
            if not request.user.is_authenticated():
                s2 += '\tUser not logged in.\n'
            else:
                s2 += '\tUser logged in as: %s\n' % request.user
                s2 += '\tRequest GET:\n%s' % \
                    self.__format_dict(request.GET, prefix='\t')
                s2 += '\tRequest POST:\n%s' % \
                    self.__format_dict(request.POST, prefix='\t')
                s2 += '\tSession:\n%s' % \
                    self.__format_dict(request.session, prefix='\t')
        except AttributeError:
            pass
        except Exception:
            s2 += traceback.format_exc()

        return '\n'.join([s, s2])

    #==========================================================================
    # Private API
    #==========================================================================
    def __format_dict(self, d, prefix=''):
        """
        Format a dictionary.

        @param d: (dict).
        @param prefix: (str) prefix for each row.
        @return: (str).
        """
        return ''.join(['%s\t%s: %s\n' % (prefix, key, value)
                        for key, value in d.iteritems()])
