# -*- coding: utf-8 -*-
from django.conf import settings
from django.contrib.auth import logout
from django.contrib.sessions.models import Session
from django.http import HttpRequest
from django.utils.importlib import import_module
from django.utils.timezone import now


def logout_all_users():
    """
    Logout all users.
    @see: https://gist.github.com/playpauseandstop/1818351.
    """
    request = HttpRequest()
    sessions = Session.objects.filter(expire_date__gte=now())

    def init_session(session_key):
        engine = import_module(settings.SESSION_ENGINE)
        return engine.SessionStore(session_key)

    for session in sessions:
        request.session = init_session(session.session_key)
        logout(request)
