# -*- coding: utf-8 -*-
import os
import sys
from django.core.management.base import BaseCommand
from optparse import make_option
from django.conf import settings
from django_addons import get_meta

class Command(BaseCommand):
    option_list = BaseCommand.option_list + (
        make_option('--enable', '-e', default=None, dest='addon_to_enable',
            help='Enable a addon'),
        make_option('--disable', '-d', default=None, dest='addon_to_disable',
            help='Disable a addon'),
    )
    help = "List, enable or disable addons."

    requires_model_validation = False
    can_import_settings = False

    def handle(self, *args, **options):
        def save(addon):
            dfile, ADDONS_ROOT = None, None
            for ADDONS_ROOT in settings.ADDONS_ROOTS:
                if os.path.exists(os.path.join(ADDONS_ROOT, addon)):
                    dfile = os.path.join(ADDONS_ROOT, settings.ADDONS_DISABLED_CONF)
                    break

            print "Saving to: %s " % dfile
            fh = open(dfile, "w")
            fh.write("# This file is automatically generated by ./manage.py addons\n")
            fh.write("# To enable an addon use: ./manage.py addons -e ADDON_NAME\n")
            fh.write("# To disable an addon use: ./manage.py addons -d ADDON_NAME\n")

            # Only writing the disabled addons related to the correct
            # ADDON_ROOT. Lets filter disabled addons from others ADDON_ROOTS
            ADDONS_DISABLED = []
            for addond in settings.ADDONS_DISABLED:
                if os.path.exists(os.path.join(ADDONS_ROOT, addond)):
                    ADDONS_DISABLED.append(addond)

            fh.write("ADDONS_DISABLED.extend([%s])\n" % ", ".join(
                "'%s'" % x for x in ADDONS_DISABLED)
                )
            fh.close()

        def addon_enable(addon):
            if not addon:
                return
            if addon in settings.ADDONS_DISABLED:
                print "Enabling addon: %s" % addon
                settings.ADDONS_DISABLED.remove(addon)
                save(addon)
            if not addon in settings.ADDONS:
                settings.ADDONS.append(addon)

        def addon_disable(addon):
            if not addon:
                return
            if addon in settings.ADDONS:
                if addon not in settings.ADDONS_DISABLED:
                    print "Disabling addon: %s" % addon
                    settings.ADDONS.remove(addon)
                    settings.ADDONS_DISABLED.append(addon)
                    save(addon)
                    return True

        # Enable addon if we have to
        addon_enable(options.get("addon_to_enable"))
        # Disable addon if we have to
        addon_disable(options.get("addon_to_disable"))

        # Otherwise display list of addon
        print "Available addons:"
        for addon in settings.ADDONS:


            print " * %s" % addon,
            meta = get_meta(addon)
            if meta:
                print "- %s" % meta.title,
            print

        for addon in settings.ADDONS_DISABLED:
            print " * %s (disabled)" % addon
