# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.contrib import admin
from django.contrib.contenttypes.generic import GenericTabularInline

from attrs.models import Attr
from attrs.forms import AttrForm, AttrFormSet
from attrs import settings as ats


class AttrInline(GenericTabularInline):
    model = Attr
    form = AttrForm
    formset = AttrFormSet
    extra = 1


class AttrsAdmin(admin.ModelAdmin):
    inlines = (AttrInline, )
    change_form_template = ats.CHANGE_FORM_TEMPLATE
