# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models
from django.db.models.signals import pre_delete
from django.dispatch import receiver
from django.contrib.contenttypes.models import ContentType
from django.contrib.contenttypes.generic import GenericForeignKey
from django.utils.translation import ugettext_lazy as _
from django.utils.encoding import python_2_unicode_compatible


@python_2_unicode_compatible
class AttrBase(models.Model):
    key = models.CharField(_('keyword'), max_length=100)
    value = models.CharField(_('value'), max_length=255)

    class Meta:
        abstract = True

    def __str__(self):
        return '{}: {}'.format(self.key, self.value)


class Attr(AttrBase):
    content_type = models.ForeignKey(ContentType)
    object_id = models.PositiveIntegerField()
    content_object = GenericForeignKey('content_type', 'object_id')

    @classmethod
    def attrs_for(cls, model, instance=None):
        content_type = ContentType.objects.get_for_model(model)
        kwargs = {'content_type': content_type}

        if instance is not None:
            kwargs['object_id'] = instance.pk

        return cls.objects.select_related().filter(**kwargs).distinct()


class AttrsModel(models.Model):
    _attrs_options = {}

    class Meta:
        abstract = True

    def get_attrs_options(self):
        return self._attrs_options


def delete_attrs(sender, instance, **kwargs):
    for attr in Attr.attrs_for(sender, instance).all():
        attr.delete()
pre_delete.connect(delete_attrs, sender=AttrsModel)
