# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.conf import settings


# Internal widget names.
WIDGET_TEXTAREA = 'textarea'
WIDGET_TEXT = 'text'
WIDGET_SELECT = 'select'


# Template to override admin change form.
CHANGE_FORM_TEMPLATE = getattr(
    settings, 'ATTRS_CHANGE_FORM_TEMPLATE', 'attrs/change_form.html')

# Field templates.
FIELD_TEXT_TEMPLATE = getattr(
    settings, 'ATTRS_FIELD_TEXT_TEMPLATE', 'attrs/fields/text.html')
FIELD_SELECT_TEMPLATE = getattr(
    settings, 'ATTRS_FIELD_SELECT_TEMPLATE', 'attrs/fields/select.html')
FIELD_TEXTAREA_TEMPLATE = getattr(
    settings, 'ATTRS_FIELD_TEXTAREA_TEMPLATE', 'attrs/fields/textarea.html')

# Default options.
DEFAULT_OPTIONS = getattr(settings, 'ATTRS_DEFAULT_OPTIONS', {})
