# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db.models.signals import pre_delete
from django.contrib import admin
from django.contrib.admin.sites import NotRegistered

from attrs.admin import AttrInline, AttrsAdmin
from attrs.models import delete_attrs
from attrs import settings as ats


def register_attrs(model, model_admin=None, options=None):
    if model_admin is None:
        model_admin = AttrsAdmin
    else:
        if not 'inlines' in model_admin.__dict__:
            model_admin.inlines = ()
        model_admin.inlines += (AttrInline, )
        model_admin.change_form_template = ats.CHANGE_FORM_TEMPLATE

    if options is not None:
        model.add_to_class('_attrs_options', options)

    try:
        admin.site.unregister(model)
    except NotRegistered:
        pass

    admin.site.register(model, model_admin)
    pre_delete.connect(delete_attrs, sender=model)
