# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import json
import ast

from django.http import HttpResponse, HttpResponseNotAllowed
from django.template.loader import render_to_string

from attrs import settings as ats


def update(request):
    if request.method == 'POST' and request.is_ajax():
        key = request.POST.get('key')
        initial = request.POST.get('initial') == 'true'
        options = ast.literal_eval(request.POST.get('options', '{}'))

        field = options.get(key, {})
        widget = field.get('widget')
        choices = field.get('choices')

        field_template = ats.FIELD_TEXT_TEMPLATE
        data = {'status': True, 'initial': initial}
        field = {
            'id': request.POST.get('id'),
            'name': request.POST.get('name'),
            'value': request.POST.get('value'),
        }

        if choices:
            field_template = ats.FIELD_SELECT_TEMPLATE
            field['choices'] = [
                {'value': x[0], 'label': x[1]} for x in choices]

        if widget == ats.WIDGET_TEXTAREA:
            field_template = ats.FIELD_TEXTAREA_TEMPLATE

        data['field_html'] = render_to_string(
            field_template, {'field': field, 'initial': initial})

        return HttpResponse(json.dumps(data), mimetype='application/json')

    return HttpResponseNotAllowed(['POST'])
