from django.db import models
from django.contrib.auth.models import User


# XXX need some indexes and unique constraints up in here where it makes sense.


class SubmissionTarget(models.Model):
    "Organization/company names and email addresses to whom we send samples"

    organization = models.CharField(max_length=150, blank=False)
    email_address = models.EmailField(blank=False)
    enabled = models.BooleanField()

    class Meta:
        ordering = ['organization']

    def __unicode__(self):
        return self.organization

class SubmissionLog(models.Model):
    """
    Log entry in database that records an instance of a successful sample
    submission. Captures file details and submission details including
    time submitted, submitter, notes, and which targets resulted in
    successful submissions (determined as those that were accepted upon
    sending via email).

    """

    file_name = models.CharField(max_length=150, blank=False)
    file_md5 = models.CharField(max_length=32, blank=False)
    file_sha1 = models.CharField(max_length=40, blank=False)
    file_sha256 = models.CharField(max_length=64, blank=False)
    file_size = models.IntegerField(max_length=9, blank=False)
    file_magic = models.CharField(max_length=100, blank=False)
    date_submitted = models.DateTimeField(auto_now_add=True)
    notes = models.CharField(max_length=1000, blank=False)
    submitter = models.ForeignKey(User, blank=False)
    submitted_to = models.ManyToManyField(SubmissionTarget, blank=False)

    def __unicode__(self):
        return "%s %s %s" % (self.date_submitted, self.file_md5, self.file_name)

    class Meta:
        ordering = ['-date_submitted']
        permissions = (
            ("submit_file", "Can submit file to recipients"),
        )

