from django.conf.urls.defaults import *
from django.contrib.auth.decorators import login_required
from django.views.generic import TemplateView, DetailView, ListView
from django.template import RequestContext

from avsubmit.models import SubmissionTarget, SubmissionLog


urlpatterns = patterns('',
    url(r'^$', 'avsubmit.views.index', name="avsubmit_index"),
    url(r'^list/$', 'avsubmit.views.list_submissions',
        name="submissionlog_list"),
    url(r'^submission/(?P<pk>\d+)/$',
        login_required(DetailView.as_view(
            model=SubmissionLog,
            template_name='submissionlog_detail.html',
            context_object_name='submissionlog',)),
        name="submissionlog_detail"),
    url(r'^submit/$','avsubmit.views.upload_file', name="upload_file"),
    url(r'^submit/dispatch/$','avsubmit.views.submit_file', name="submit_file"),
)

