"Validator functions"

import logging

from django.conf import settings
from django.core.exceptions import ValidationError


logger = logging.getLogger('project.default')

def validate_filesize_limit(value):
    """
    Validate that size (in bytes) of value is not greater than the allotted
    size limit for uploads.

    """
    max_size = settings.AVSUBMIT_SETTINGS['max_upload_size']
    if int(value.size) > int(max_size):
        errstr = u"File size %s exceeds allowed upload size limit (%s)" % (value.size, max_size)
        logger.error(errstr)
        raise ValidationError(errstr)
